<?php
// session_start(); & DB
require('../config/db.php');
include 'session.php';

$limit = 50;

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) {
  $page = 1;
}

// offset calculation
$offset = ($page - 1) * $limit;

// Fetch all orders
$status = $_GET['status'] ?? 'all';



$allowed_statuses = ['pending', 'canceled', 'processing', 'inprogress', 'partial', 'completed'];


// all
// build base query
if ($status === 'all') {
  $query = "SELECT * FROM orders ORDER BY id DESC LIMIT $limit OFFSET $offset";
} elseif ($status === 'failed_initiated') {
  $query = "SELECT * FROM orders WHERE status IN ('failed','initiated') ORDER BY id DESC LIMIT $limit OFFSET $offset";
} else {
  $status = strtolower($status);
  if (in_array($status, $allowed_statuses)) {
    $query = "SELECT * FROM orders WHERE status='$status' ORDER BY id DESC LIMIT $limit OFFSET $offset";
  } else {
    $query = "SELECT * FROM orders ORDER BY id DESC LIMIT $limit OFFSET $offset";
  }
}
$result = mysqli_query($connect, $query);


// மொத்த rows count
$count_query = "SELECT COUNT(*) as total FROM orders";
if ($status === 'failed_initiated') {
  $count_query = "SELECT COUNT(*) as total FROM orders WHERE status IN ('failed','initiated')";
} elseif (in_array($status, $allowed_statuses)) {
  $count_query = "SELECT COUNT(*) as total FROM orders WHERE status='$status'";
}
$count_result = mysqli_query($connect, $count_query);
$count_row = mysqli_fetch_assoc($count_result);
$total_records = $count_row['total'];

// மொத்த pages எவ்வளவு?
$total_pages = ceil($total_records / $limit);

?>

<?php
// Check if there are any failed or initiated orders

$check_any = mysqli_query($connect, "
  SELECT COUNT(*) as total 
  FROM orders 
  WHERE status = 'Failed' OR status = 'initiated'
");
$any_row = mysqli_fetch_assoc($check_any);
$has_failed_or_initiated = $any_row['total'] > 0;



?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>All Orders</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <!-- trosted link -->

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

  <!-- trosted end -->
</head>

<body class="bg-light">






  <!-- toastr alerts -->
  <?php if (isset($_SESSION['success'])): ?>
    <script>
      document.addEventListener('DOMContentLoaded', function() {
        toastr.success("<?= addslashes($_SESSION['success']); ?>", "Success", {
          closeButton: true,
          progressBar: true,
          positionClass: "toast-top-right",
          timeOut: 3000,
        });
      });
    </script>
    <?php unset($_SESSION['success']); ?>
  <?php endif; ?>

  <?php if (isset($_SESSION['error'])): ?>
    <script>
      document.addEventListener('DOMContentLoaded', function() {
        toastr.error("<?= addslashes($_SESSION['error']); ?>", "Error", {
          closeButton: true,
          progressBar: true,
          positionClass: "toast-top-right",
          timeOut: 3000,
        });
      });
    </script>
    <?php unset($_SESSION['error']); ?>
  <?php endif; ?>

  <?php if (isset($_SESSION['info'])): ?>
    <script>
      document.addEventListener('DOMContentLoaded', function() {
        toastr.info("<?= addslashes($_SESSION['info']); ?>", "Info", {
          closeButton: true,
          progressBar: true,
          positionClass: "toast-top-right",
          timeOut: 3000,
        });
      });
    </script>
    <?php unset($_SESSION['info']); ?>
  <?php endif; ?>
  <!-- toastr end -->






  <?php include 'include/header.php'; ?>
  <div class="container mt-4">
    <div class="card shadow p-4">

      <h4 class="mb-3 fw-bold text-center">📦 All Orders</h4>
      <div class="table-responsive">
        <input type="text" id="searchInput" class="form-control mb-3" placeholder="Search...">

        <!-- status filter btns -->
        <form method="GET" action="" id="filterForm">
          <input type="hidden" name="status" id="statusInput" value="all">

          <div class="mb-3 text-center">
            <div class="d-flex flex-wrap justify-content-center gap-2">
              <button type="submit" class="btn btn-warning" onclick="document.getElementById('statusInput').value='pending'">Pending</button>
              <button type="submit" class="btn btn-secondary" onclick="document.getElementById('statusInput').value='canceled'">Canceled</button>
              <button type="submit" class="btn btn-primary" onclick="document.getElementById('statusInput').value='processing'">Processing</button>
              <button type="submit" class="btn btn-primary" onclick="document.getElementById('statusInput').value='inprogress'">In Progress</button>
              <button type="submit" class="btn btn-primary" onclick="document.getElementById('statusInput').value='partial'">Partial</button>
              <button type="submit" class="btn btn-danger" onclick="document.getElementById('statusInput').value='failed_initiated'">Failed + Initiated</button>
              <button type="submit" class="btn btn-success" onclick="document.getElementById('statusInput').value='completed'">Completed</button>
              <button type="submit" class="btn btn-dark" onclick="document.getElementById('statusInput').value='all'">Show All</button>
            </div>
          </div>
        </form>



        <form method="POST" action="more/order_status_update.php" id="bulkStatusForm" onsubmit="return confirm('Are you sure you want to update status for selected orders?')">
          <div class="d-flex flex-wrap justify-content-between align-items-center gap-2 mb-3">

            <!-- hid class styl -->
            <style>
              .hide {
                display: none !important;
              }
            </style>

            <!-- status upodate box -->
            <div class="status-update-container   status-update-container d-flex flex-wrap gap-2 align-items-center">
              <select name="new_status" class="form-select" required style="min-width: 180px;">
                <option value="">-- Select Status --</option>
                <option value="pending">Pending</option>
                <option value="processing">Processing</option>
                <option value="inprogress">Inprogress</option>
                <option value="partial">Partial</option>
                <option value="canceled">Canceled</option>
                <option value="completed">Completed</option>
                <option value="resend_api">Resend Api</option>
              </select>
              <button type="submit" class="btn btn-success">Update Status</button>
            </div>


            <script>
              // scrip hid or show status update boxx
              $(document).ready(function() {

                // ✅ Show/hide with class toggle
                function toggleStatusUpdateContainer() {
                  const selected = $('input[name="selected_ids[]"]:checked').length;
                  if (selected > 0) {
                    $('.status-update-container').removeClass('hide');
                  } else {
                    $('.status-update-container').addClass('hide');
                  }
                }

                // Individual checkbox
                $(document).on('change', 'input[name="selected_ids[]"]', function() {
                  toggleStatusUpdateContainer();
                });

                // Select All checkbox
                $('#selectAll').on('change', function() {
                  const isChecked = $(this).is(':checked');
                  $('input[name="selected_ids[]"]').prop('checked', isChecked);
                  toggleStatusUpdateContainer();
                });

                // On page load, ensure it's hidden
                $('.status-update-container').addClass('hide');
              });
            </script>









            <table id="orderTable" class="table table-bordered table-striped table-hover text-center nowrap" style="width:100%">
              <thead class="table-dark">
                <tr>
                  <th><input type="checkbox" id="selectAll"></th>
                  <th>#</th>
                  <th>Username</th>
                  <th>Service Name</th>
                  <th>Quantity</th>
                  <th>Price</th>
                  <th>Status</th>
                  <th>All Status</th>
                  <th>Action</th>

                </tr>
              </thead>
              <tbody>
                <?php while ($row = mysqli_fetch_assoc($result)) {
                  $json_data = htmlspecialchars(json_encode($row), ENT_QUOTES); // for modal
                ?>
                  <tr>
                    <!-- tik box -->
                    <td class="text-center">
                      <input type="checkbox" name="selected_ids[]" value="<?= $row['id'] ?>">
                    </td>
                    <td><?= $row['id']; ?></td>
                    <td><?= htmlspecialchars($row['username']); ?></td>
                    <td><?= htmlspecialchars($row['sarvice_name']); ?></td>
                    <td><?= htmlspecialchars($row['quantity']); ?></td>
                    <td>LKR <?= number_format($row['price'], 2); ?></td>
                    <td> <?= htmlspecialchars($row['status']); ?></td>


                    <?php
                    $row_status  = strtolower($row['status']); // small letters-ஆ convert பண்ணலாம்

                    // Default btn color & btn color based on status
                    $btn_class = "btn-primary";

                    if ($row_status  === 'failed' || $status === 'initiated') {
                      $btn_class = "btn-danger";      // Red button
                    } elseif ($row_status  === 'completed') {
                      $btn_class = "btn-success";     // Green button
                    } elseif ($row_status  === 'pending') {
                      $btn_class = "btn-warning";     // Yellow button
                    } elseif ($row_status  === 'canceled' || $status === 'canceled') {
                      $btn_class = "btn-secondary";   // Grey button
                    }
                    ?>
                    <td>
                      <button class="btn <?= $btn_class; ?> btn-sm" onclick='showDetails(<?= $json_data; ?>)'>View More</button>
                    </td>
                    <td>
                      <?php if ($row['status'] !== 'canceled' && $row['status'] !== 'cancel') { ?>
                        <a href="cancell_order.php?id=<?= $row['id']; ?>" class="btn btn-danger btn-sm"
                          onclick="return confirm('Are you sure you want to cancel this order?');">Cancel</a>
                      <?php } else { ?>
                        <span class="text-muted">Cancelled</span>
                      <?php } ?>
                    </td>
                  </tr>
                <?php } ?>
              </tbody>
            </table>
            <?php
            $max_pages_to_show = 8; // dfal show 8 page
            $start_page = max(1, $page - 2); // தற்போது பக்கம் 2 ஆக இருந்தால், 1 தொடக்கம் காட்ட
            $end_page = min($total_pages, $start_page + $max_pages_to_show - 1);

            // start_page - end_page இடையே 5 பக்கங்கள் இருக்கும்
            // ஆனால் end_page அதிகமாக இருந்தால் start_page-ஐ adjust செய்யலாம்

            if ($end_page - $start_page + 1 < $max_pages_to_show) {
              $start_page = max(1, $end_page - $max_pages_to_show + 1);
            }
            ?>

            <nav class="z-0 position-relative">
              <ul class="pagination justify-content-center mt-3">
                <?php for ($i = $start_page; $i <= $end_page; $i++): ?>
                  <li class="page-item <?= ($i == $page) ? 'active' : '' ?>">
                    <a class="page-link" href="?status=<?= urlencode($status) ?>&page=<?= $i ?>"><?= $i ?></a>
                  </li>
                <?php endfor; ?>

                <!-- Last page button -->
                <?php if ($end_page < $total_pages): ?>
                  <li class="page-item">
                    <a class="page-link" href="?status=<?= urlencode($status) ?>&page=<?= $total_pages ?>">
                      Last &raquo;
                    </a>
                  </li>
                <?php endif; ?>
              </ul>
            </nav>



        </form>
      </div>
    </div>
  </div>


  <!-- Modal -->
  <div class="modal fade" id="orderModal" tabindex="-1" aria-labelledby="orderModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
      <!-- modal-xl → wide screen, scrollable → body scrolls if content large -->
      <div class="modal-content shadow-lg rounded-3 border-0">
        <div class="modal-header text-dark">
          <h5 class="modal-title fw-bold" id="orderModalLabel">Order Details</h5>
          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body p-3">
          <div class="table-responsive">
            <table class="table table-bordered table-hover align-middle mb-0">
              <tbody id="orderDetailsBody"></tbody>
            </table>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>






  <script>
    // Update hidden input fields when checkboxes change
    $(document).on('change', 'input[name="selected_ids[]"], #selectAll', function() {
      const selectedIds = $('input[name="selected_ids[]"]:checked')
        .map(function() {
          return $(this).val();
        }).get();

      let inputs = '';
      selectedIds.forEach(function(id) {
        inputs += `<input type="hidden" name="selected_ids[]" value="${id}">`;
      });

      $('#selectedIdsContainer').html(inputs);
    });
  </script>















  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>




  <script>
    function showDetails(order) {
      let html = '';
      for (let key in order) {
        html += `
      <tr>
        <th class="text-capitalize" style="width:35%; min-width:120px;">${key.replace('_', ' ')}</th>
        <td class="text-truncate" style="max-width:400px;">${order[key]}</td>
      </tr>
    `;
      }
      $('#orderDetailsBody').html(html);

      if (order.id) {
        console.log("Fetching provider for order id:", order.id); // check in console
        showProvider(order.id);
      }

      var modal = new bootstrap.Modal(document.getElementById('orderModal'));
      modal.show();
    }

    function showProvider(orderId) {
      $.ajax({
        url: 'more/fetch_provider.php',
        method: 'POST',
        data: {
          order_id: orderId
        },
        dataType: 'json',
        success: function(response) {
          console.log("Provider response:", response);
          if (response.status === 'success') {
            let html = `
         
          <tr><th>API URL</th><td>${response.provider.api_url}</td></tr>
        `;
            $('#orderDetailsBody').append(html);
          } else {
            $('#orderDetailsBody').append(`
          <tr><td colspan="2" class="text-center text-danger">${response.message}</td></tr>
        `);
          }
        },
        error: function(xhr, status, error) {
          console.error("AJAX Error:", status, error, xhr.responseText);
          $('#orderDetailsBody').append(`
        <tr><td colspan="2" class="text-center text-danger">AJAX Error</td></tr>
      `);
        }
      });
    }
  </script>




  <script>
    $(document).ready(function() {
      // Search function
      $('#searchInput').on('input', function() {
        var value = $(this).val().toLowerCase();
        $("#orderTable tbody tr").filter(function() {
          $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
        });
      });
    });
  </script>










  <!-- Scripts -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
  <script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
  <script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>