<?php include 'session.php'; ?>
<?php
// DB Connection
include '../config/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit'])) {
    $payment_method = $_POST['payment_method'];
    $account_name = $_POST['account_name'];
    $account_number = $_POST['account_number'];
    $branch = $_POST['branch'];
    $message = $_POST['message'];
    $id = $_POST['id'];

    // Update the bank details in the database
    $stmt = $connect->prepare("UPDATE bank_details SET payment_method=?, account_name=?, account_number=?, branch=?, message=? WHERE id=?");
    $stmt->bind_param("sssssi", $payment_method, $account_name, $account_number, $branch, $message, $id);
    $stmt->execute();
    $msg = "Bank details updated successfully!";
}
elseif ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete'])) {
    $id = $_POST['id'];

    // Delete the bank details from the database
    $stmt = $connect->prepare("DELETE FROM bank_details WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $msg = "Bank details deleted successfully!";
}

// Fetch bank details from the database
$result = $connect->query("SELECT * FROM bank_details");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bank Details</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include 'include/header.php'; ?>


<div class="container mt-5">

    <div class="card shadow p-4">
        <h3 class="mb-4">Bank Details</h3>
        
        <!-- Success Message -->
        <?php if (isset($msg)): ?>
            <div class="alert alert-success"><?= htmlspecialchars($msg) ?></div>
        <?php endif; ?>

        <!-- Table to show bank details -->
<a href="add_bank" class="btn btn-primary mb-2">Add Payment Method</a>
<input type="text" id="searchInput" class="form-control mb-3" placeholder="Search...">

<div class="table-responsive"> <!-- Wrap the table in a responsive div -->
    <table class="table table-striped table-bordered" id="userBalanceTable">
        <thead>
            <tr>
                <th>#</th>
                <th>Payment Method</th>
                <th>Account Name</th>
                <th>Account Number</th>
                <th>Branch</th>
                <th>Message</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?= $row['id'] ?></td>
                    <td><?= $row['payment_method'] ?></td>
                    <td><?= $row['account_name'] ?></td>
                    <td><?= $row['account_number'] ?></td>
                    <td><?= $row['branch'] ?></td>
                    <td><?= $row['message'] ?></td>
                    <td>
                        <!-- Edit button -->
                        <button class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#editModal" onclick="editBankDetail(<?= $row['id'] ?>, '<?= $row['payment_method'] ?>', '<?= $row['account_name'] ?>', '<?= $row['account_number'] ?>', '<?= $row['branch'] ?>', '<?= $row['message'] ?>')">Edit</button>
                        <!-- Delete button -->
                        <form method="post" class="d-inline">
                            <input type="hidden" name="id" value="<?= $row['id'] ?>">
                            <button type="submit" name="delete" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this bank detail?')">Delete</button>
                        </form>
                    </td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>

    </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editModalLabel">Edit Bank Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form method="post">
            <input type="hidden" name="id" id="editId">
            <div class="mb-3">
                <label for="payment_method" class="form-label">Payment Method</label>
                <input type="text" name="payment_method" id="editPaymentMethod" class="form-control" required>
            </div>
            <div class="mb-3">
                <label for="account_name" class="form-label">Account Name</label>
                <input type="text" name="account_name" id="editAccountName" class="form-control" required>
            </div>
            <div class="mb-3">
                <label for="account_number" class="form-label">Account Number</label>
                <input type="text" name="account_number" id="editAccountNumber" class="form-control" required>
            </div>
            <div class="mb-3">
                <label for="branch" class="form-label">Branch</label>
                <input type="text" name="branch" id="editBranch" class="form-control" required>
            </div>
            <div class="mb-3">
                <label for="message" class="form-label">Message</label>
                <textarea name="message" id="editMessage" class="form-control" rows="3"></textarea>
            </div>
            <button type="submit" name="edit" class="btn btn-primary">Save Changes</button>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
    // Fill the modal with data for editing
    function editBankDetail(id, payment_method, account_name, account_number, branch, message) {
        document.getElementById('editId').value = id;
        document.getElementById('editPaymentMethod').value = payment_method;
        document.getElementById('editAccountName').value = account_name;
        document.getElementById('editAccountNumber').value = account_number;
        document.getElementById('editBranch').value = branch;
        document.getElementById('editMessage').value = message;
    }
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        // Search function
        $('#searchInput').on('input', function() {
            var value = $(this).val().toLowerCase();
            $("#userBalanceTable tbody tr").filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
            });
        });
    });
</script>
</body>
</html>
