<?php
include '../config/db.php'; // DB connection
include 'session.php';

$users = $connect->query("SELECT id, username FROM users2");
$services = $connect->query("SELECT id, service_name FROM services");
?>
<!DOCTYPE html>
<html lang="en">

<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Set Custom Quantity</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
</head>

<body>

<?php include 'include/header.php'; ?>

<div class="container mt-5">
  <div class="row justify-content-center">
    <div class="col-12 col-md-8 col-lg-6">
      <div class="card shadow-lg border-0 rounded-4">
        <div class="card-header bg-primary text-white text-center rounded-top-4">
          <h4 class="mb-0 fw-bold">📦 Set Custom Quantity</h4>
        </div>
        <div class="card-body bg-light">
          <form method="POST" action="custom_quantity_manager.php">
            <input type="hidden" name="action" value="add" />

            <!-- User -->
            <div class="mb-3">
              <label for="addUser" class="form-label fw-semibold">👤 User</label>
              <select name="user_id" id="addUser" class="form-select select2" required>
                <option value="">-- Select User --</option>
                <?php while ($u = $users->fetch_assoc()) { ?>
                  <option value="<?= $u['id'] ?>"><?= htmlspecialchars($u['username']) ?> (ID: <?= $u['id'] ?>)</option>
                <?php } ?>
              </select>
            </div>

            <!-- Service -->
            <div class="mb-3">
              <label for="addService" class="form-label fw-semibold">📦 Service</label>
              <select name="service_id" id="addService" class="form-select select2" required>
                <option value="">-- Select Service --</option>
                <?php while ($s = $services->fetch_assoc()) { ?>
                  <option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['service_name']) ?> (ID: <?= $s['id'] ?>)</option>
                <?php } ?>
              </select>
            </div>

            <!-- Minimum Quantity -->
            <div class="mb-3">
              <label class="form-label fw-semibold">📉 Minimum Quantity</label>
              <input type="number" min="0" step="1" name="min_quantity" class="form-control shadow-sm" placeholder="Eg: 10" required>
            </div>

            <!-- Maximum Quantity -->
            <div class="mb-3">
              <label class="form-label fw-semibold">📈 Maximum Quantity</label>
              <input type="number" min="0" step="1" name="max_quantity" class="form-control shadow-sm" placeholder="Eg: 100" required>
            </div>

            <div class="d-grid">
              <button type="submit" class="btn btn-success fw-bold">💾 Save Quantity</button>
            </div>
          </form>
        </div>
        <div class="card-footer text-center small text-muted">Powered by Muaath 💡</div>
      </div>
    </div>
  </div>
</div>

<script>
$(document).ready(function() {
  $('.select2').select2({
    placeholder: "🔍 Search here...",
    allowClear: true,
    width: '100%'
  });
});
</script>

<script>
$(document).ready(function () {
    $('.select2').select2({
        placeholder: "🔍 Search here...",
        allowClear: true,
        width: '100%'
    });

    $('#addService').change(function () {
        var serviceId = $(this).val();

        if (serviceId) {
            $.ajax({
                url: 'get_filles/get_default_quantity.php',
                type: 'GET',
                data: { service_id: serviceId },
                success: function (response) {
                    try {
                        var data = JSON.parse(response);
                        $('input[name="min_quantity"]').val(data.min_quantity);
                        $('input[name="max_quantity"]').val(data.max_quantity);
                    } catch (e) {
                        console.error("Invalid JSON response:", response);
                    }
                }
            });
        } else {
            $('input[name="min_quantity"]').val('');
            $('input[name="max_quantity"]').val('');
        }
    });
});
</script>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
