<?php
include 'session.php';
include '../config/db.php';

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ||
    $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$host = $_SERVER['HTTP_HOST'];
$domain = $protocol . $host; // 👈 subfolder சேர்க்கவே வேண்டாம்





// Fetch existing setting (only 1 row expected)
$result = $connect->query("SELECT * FROM ez_auto_payment_setting LIMIT 1");
$data = $result->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $ez_number = $_POST['ez_number'];
    $offers_percentage = intval($_POST['offers_percentage']);
    $status = isset($_POST['status']) ? 1 : 0;
    $website_url = $_POST['website_url'];

    if ($data) {
        // Update existing row
        $stmt = $connect->prepare("UPDATE ez_auto_payment_setting SET ez_number=?, offers_percentage=?, status=?, website_url=? WHERE id=?");
        $stmt->bind_param("siisi", $ez_number, $offers_percentage, $status, $website_url, $data['id']);
        $stmt->execute();
        $message = "Updated Successfully";
    } else {
        // Insert new row
        $stmt = $connect->prepare("INSERT INTO ez_auto_payment_setting (ez_number, offers_percentage, status, website_url) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("siis", $ez_number, $offers_percentage, $status, $website_url);
        $stmt->execute();
        $message = "Inserted Successfully";
    }

    header("Location: ez_auto_payment_setting.php?msg=" . urlencode($message));
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Ez Auto Payment Setting</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>

<?php include 'include/header.php'; ?>

<body class="bg-light">

    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5">
                <div class="card shadow-lg">
                    <div class="card-body p-4">

                        <h3 class="card-title mb-4 text-center">Ez Auto Payment Setting</h3>

                        <?php if (isset($_GET['msg'])): ?>
                            <div class="alert alert-success text-center"><?= htmlspecialchars($_GET['msg']) ?></div>
                        <?php endif; ?>

                        <form method="post">
                            <div class="mb-3">
                                <label class="form-label">Ez Number</label>
                                <input type="text" name="ez_number" class="form-control" required value="<?= htmlspecialchars($data['ez_number'] ?? '') ?>">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Offers Percentage (%)</label>
                                <input type="number" name="offers_percentage" min="0" max="100" class="form-control" required value="<?= htmlspecialchars($data['offers_percentage'] ?? '') ?>">
                            </div>

                            <div class="mb-3 form-check">
                                <input type="checkbox" class="form-check-input" name="status" id="statusCheck" <?= isset($data['status']) && $data['status'] == 1 ? 'checked' : '' ?>>
                                <label class="form-check-label" for="statusCheck">Active</label>
                            </div>



                            <div class="mb-3">
                                <label class="form-label">Ez rest api url </label>
                                <div class="input-group">
                                    <input type="url" id="websiteUrl" name="website_url" class="form-control" value="<?= $domain . "/public/payments/ez_rest_api" ?>" readonly>
                                    <button class="btn btn-outline-secondary" type="button" id="copyBtn1">Copy</button>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Whatsapp Order api url </label>
                                <div class="input-group">
                                    <input type="url" id="whatsappurl" name="whatsappurl" class="form-control" value="<?= $domain . "/api/whatsapp" ?>" readonly>
                                    <button class="btn btn-outline-secondary" type="button" id="copyBtn2">Copy</button>
                                </div>
                            </div>



                            <button type="submit" class="btn btn-primary w-100">Save Setting</button>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>



    <script>
        document.getElementById('copyBtn1').addEventListener('click', function() {
            const url = document.getElementById('websiteUrl').value;
            navigator.clipboard.writeText(url).then(() => {
                alert('Ez rest api url copied!');
            }).catch(() => {
                alert('Failed to copy. Please copy manually.');
            });
        });

        document.getElementById('copyBtn2').addEventListener('click', function() {
            const url = document.getElementById('whatsappurl').value;
            navigator.clipboard.writeText(url).then(() => {
                alert('Whatsapp Order api url copied!');
            }).catch(() => {
                alert('Failed to copy. Please copy manually.');
            });
        });
    </script>

</body>

</html>