<?php
include 'session.php';
include '../config/db.php';
header('Content-Type: application/json');

// Provider session check
if (!isset($_SESSION['selected_provider_id'])) {
    echo json_encode(["status" => "error", "message" => "No provider selected"]);
    exit();
}

$provider_id = $_SESSION['selected_provider_id'];

//  Read JSON data from frontend
$raw = file_get_contents("php://input");
$data = json_decode($raw, true);

$import_services = $data['batch_data'] ?? [];
$extra_percent = isset($data['extra_percent']) ? floatval($data['extra_percent']) : 0;

// Helper: choose description key
function getDescription($service)
{
    $possibleKeys = ['desc', 'description', 'Description', 'details'];
    foreach ($possibleKeys as $key) {
        if (isset($service[$key]) && !empty($service[$key])) {
            return $service[$key];
        }
    }
    return '';
}

// Helper: get or create category ID
function getCategoryId($connect, $category_name)
{
    $category_name_escaped = $connect->real_escape_string($category_name);
    $result = $connect->query("SELECT id FROM category WHERE category_name = '$category_name_escaped' LIMIT 1");
    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        return $row['id'];
    } else {
        $connect->query("INSERT INTO category (category_name, in_order) VALUES ('$category_name_escaped', 10)");
        return $connect->insert_id;
    }
}

$inserted_count = 0;
$errors = [];

if (!empty($import_services)) {
    foreach ($import_services as $service) {
        if (empty($service['service_id']) || empty($service['name'])) continue;

        $service_id = $connect->real_escape_string($service['service_id']);
        $category_name = $service['category'] ?? 'Uncategorized';
        $category_id = getCategoryId($connect, $category_name);

        $name = $connect->real_escape_string($service['name']);
        $type = $connect->real_escape_string($service['type'] ?? '');
        $rate = floatval($service['rate']);
        $min = intval($service['min'] ?? 0);
        $max = intval($service['max'] ?? 0);
        $refill = intval($service['refill'] ?? 0);
        $desc_raw = getDescription($service);
        $desc = $connect->real_escape_string($desc_raw);

        // if ($extra_percent > 0) {
        //     $rate += ($rate * $extra_percent / 100);
        // }

        // Check if service already exists (avoid duplicates)
        $check = $connect->query("SELECT id FROM services WHERE api_order_id='$service_id' AND provider_id='$provider_id' LIMIT 1");
        if ($check && $check->num_rows > 0) {
            continue; // skip duplicates
        }

        $sql = "INSERT INTO services 
                (api_order_id, category_id, service_name, price, min_quantity, max_quantity, refill_button, description, provider_id)
                VALUES ('$service_id', '$category_id', '$name', '$rate', '$min', '$max', '$refill', '$desc', '$provider_id')";

        if ($connect->query($sql)) {
            $inserted_count++;
        } else {
            $errors[] = "Failed to insert service $service_id: " . $connect->error;
        }
    }

    echo json_encode([
        "status" => "success",
        "inserted" => $inserted_count,
        "errors" => $errors
    ]);
} else {
    echo json_encode(["status" => "error", "message" => "No data received"]);
}
