<?php
include '../../config/db.php';

$service_id = $_GET['service_id'] ?? 0;

if (!$service_id) {
    echo json_encode(['min_quantity' => '', 'max_quantity' => '']);
    exit;
}

$query = $connect->prepare("SELECT min_quantity, max_quantity FROM services WHERE id = ?");
$query->bind_param("i", $service_id);
$query->execute();
$result = $query->get_result();

if ($row = $result->fetch_assoc()) {
    echo json_encode([
        'min_quantity' => $row['min_quantity'],
        'max_quantity' => $row['max_quantity']
    ]);
} else {
    echo json_encode(['min_quantity' => '', 'max_quantity' => '']);
}
?>
