<?php
include '../config/db.php';
include 'session.php';

$users = $connect->query("SELECT id, username FROM users2");
$categories = $connect->query("SELECT id, category_name FROM category");
?>

<?php
// Handle form submission to hide category for user

if ($_SERVER['REQUEST_METHOD'] == 'POST' && $_POST['action'] == 'hide_category') {
    $user_id = $_POST['user_id'];
    $category_id = $_POST['category_id'];
    $status = isset($_POST['status']) ? $_POST['status'] : null;

    $stmt = $connect->prepare("INSERT INTO hide_category (user_id, category_id, status) VALUES (?, ?, ?)");
    $stmt->bind_param("iii", $user_id, $category_id, $status);

    if ($stmt->execute()) {
        $_SESSION['success'] = "Category hidden successfully!";
        header("Location: " . $_SERVER['PHP_SELF']);
        exit();
    } else {
        $_SESSION['error'] = "Failed to hide category: " . $stmt->error;
    }
}
?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Hide Category for User</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <!-- Toastr CSS & JS CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

</head>

<body>

    <?php include 'include/header.php'; ?>

    <!-- Toastr Alert -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            <?php if (isset($_SESSION['success'])): ?>
                toastr.success("<?= $_SESSION['success'] ?>", "Success", {
                    closeButton: true,
                    progressBar: true,
                    positionClass: "toast-top-right"
                });
            <?php unset($_SESSION['success']);
            endif; ?>

            <?php if (isset($_SESSION['error'])): ?>
                toastr.error("<?= $_SESSION['error'] ?>", "Error", {
                    closeButton: true,
                    progressBar: true,
                    positionClass: "toast-top-right"
                });
            <?php unset($_SESSION['error']);
            endif; ?>
        });
    </script>

    <div class="container mt-5">
        <div class="card shadow border-0 rounded-4">
            <div class="card-header bg-danger text-white text-center">
                <h4>🙈 Hide Category for User</h4>
            </div>
            <div class="card-body bg-light">
                <form method="POST" action="">
                    <input type="hidden" name="action" value="hide_category" />

                    <div class="mb-3">
                        <label class="form-label fw-semibold">👤 User</label>
                        <select name="user_id" class="form-select select2" required>
                            <option value="">-- Select User --</option>
                            <?php while ($u = $users->fetch_assoc()) { ?>
                                <option value="<?= $u['id'] ?>"><?= htmlspecialchars($u['username']) ?> (ID: <?= $u['id'] ?>)</option>
                            <?php } ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-semibold">📂 Category</label>
                        <select name="category_id" class="form-select select2" required>
                            <option value="">-- Select Category --</option>
                            <?php while ($c = $categories->fetch_assoc()) { ?>
                                <option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['category_name']) ?> (ID: <?= $c['id'] ?>)</option>
                            <?php } ?>
                        </select>
                    </div>

                    <input type="hidden" name="status" value="1">


                    <div class="d-grid">
                        <button type="submit" class="btn btn-danger fw-bold">🙈 Hide Category</button>
                    </div>
                </form>
            </div>
            <div class="card-footer text-center small text-muted">Powered by Muaath 💡</div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $('.select2').select2({
                placeholder: "🔍 Search here...",
                width: '100%',
                allowClear: true
            });
        });
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>

</html>