<?php
require('../../config/db.php');
include '../../api/api_class.php';
session_start();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_status = mysqli_real_escape_string($connect, $_POST['new_status']);
    $selected_ids = $_POST['selected_ids'] ?? [];



    if ($new_status === 'resend_api') {
        // Store selected IDs in session or hidden form
        // Step 1: Get selected orders only if POST has selected_ids
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['selected_ids'])) {
            $selected_ids = array_map('intval', $_POST['selected_ids']);
            $ids_str = implode(",", $selected_ids);

            // slct selected get status based cheak
            $failed_orders_q = mysqli_query($connect, "
        SELECT orders.*, services.api_order_id, services.provider_id 
        FROM orders 
        JOIN services ON orders.service_id = services.id 
        WHERE orders.id IN ($ids_str) 
        AND (orders.status = 'failed' OR orders.status = 'initiated')
    ");



            // slct all get 
            //$failed_orders_q = mysqli_query($connect, "
            //SELECT orders.*, services.api_order_id, services.provider_id 
            //FROM orders 
            // JOIN services ON orders.service_id = services.id 
            //WHERE orders.id IN ($ids_str)


        }


        if (mysqli_num_rows($failed_orders_q) == 0) {
            $_SESSION['error'] = "❌ No failed orders found.";
            header("Location: ../all_orders");
            exit;
        }

        while ($order = mysqli_fetch_assoc($failed_orders_q)) {
            $service_id = intval($order['service_id']);
            $link = $order['link'];
            $quantity = intval($order['quantity']);
            $order_db_id = intval($order['id']);
            $api_service_id = intval($order['api_order_id']);
            $provider_id = intval($order['provider_id']);

            if (!$api_service_id || !$provider_id) {
                continue; // skip if not configured
            }

            // ✅ Get provider API credentials
            $provider_q = mysqli_query($connect, "SELECT api_key, api_url FROM providers WHERE id = $provider_id");
            $provider = mysqli_fetch_assoc($provider_q);

            if (!$provider || empty($provider['api_key']) || empty($provider['api_url'])) {
                continue; // skip if missing
            }


            $api_key = $provider['api_key'];
            $api_url = $provider['api_url'];

            $api = new Api($api_key, $api_url);

            // Prepare data
            $data = [
                'service' => $api_service_id,
                'link' => $link,
                'quantity' => $quantity
            ];

            // API Call
            $api_response = $api->order($data);
            $response_json = mysqli_real_escape_string($connect, json_encode($api_response));

            if (isset($api_response->order) && is_numeric($api_response->order)) {
                $api_order_id = $api_response->order;
                mysqli_query($connect, "
            UPDATE orders 
            SET api_order_id = '$api_order_id', status = 'pending', api_response = '$response_json' 
            WHERE id = $order_db_id
        ");
            } else {
                mysqli_query($connect, "
            UPDATE orders 
            SET status = 'failed', api_response = '$response_json' 
            WHERE id = $order_db_id
        ");
            }
        }

        $_SESSION['success'] = "✅ Slected orders re-sent to respective provider APIs.";
        header("Location: ../all_orders");
        exit;
    }

    if ($new_status === "canceled") {
        if (!empty($selected_ids)) {
            foreach ($selected_ids as $id) {
                $id = (int)$id;
                // அந்த order details-ஐ எடு
                $order_q = mysqli_query($connect, "SELECT username, price, start_count, remains FROM orders WHERE id=$id");
                if ($order = mysqli_fetch_assoc($order_q)) {
                    $username = $order['username'];
                    $price = (float)$order['price'];
                    $start_count = (int)$order['start_count'];
                    $remains = (int)$order['remains'];

                    // user balance update
                    $uq = mysqli_query($connect, "SELECT balance FROM users2 WHERE username='$username'");
                    if ($user = mysqli_fetch_assoc($uq)) {
                        $new_balance = $user['balance'] + $price;
                        mysqli_query($connect, "UPDATE users2 SET balance=$new_balance WHERE username='$username'");

                        // history
                        $action = 'refund';
                        $today = date('Y-m-d');
                        $insertHistory = "INSERT INTO balance_history (username, date, amount, action) VALUES (?, ?, ?, ?)";
                        $stmt = mysqli_prepare($connect, $insertHistory);
                        mysqli_stmt_bind_param($stmt, "ssds", $username, $today, $price, $action);
                        mysqli_stmt_execute($stmt);
                        mysqli_stmt_close($stmt);
                    }

                    // order update
                    mysqli_query($connect, "UPDATE orders SET status='canceled', start_count=$start_count, remains=$remains, price=0 WHERE id=$id");
                }
            }
            $_SESSION['success'] = "✅ Selected orders canceled and refunded.";
            header("Location: ../all_orders");
            exit;
        }

        $_SESSION['error'] = "❌ No orders selected.";
        header("Location: ../all_orders");
        exit;
    }

    if (!empty($selected_ids)) {
        foreach ($selected_ids as $id) {
            $id = (int)$id;
            mysqli_query($connect, "UPDATE orders SET status = '$new_status' WHERE id = $id");
        }

        $_SESSION['success'] = "✅ Status updated successfully.";
        header("Location: ../all_orders");
        exit;
    } else {
        $_SESSION['error'] = "❌ No orders selected.";
        header("Location: ../all_orders");
        exit;
    }
} else {
    echo "❌ Invalid request.";
}
