<?php include 'session.php'; ?>
<?php include '../config/db.php'; ?>

<?php


// api class 

include '../api/api_class.php';


// funsen fill ness balnce canvort provider
include '../public/function/currency.php';


// // get data
if ($_SERVER['REQUEST_METHOD'] === 'POST') {



    $id = $_POST['id'] ?? '';
    $api_url = $_POST['api_url'];
    $api_key = $_POST['api_key'];;

    $api = new Api($api_key, $api_url);
    $balance_response = $api->balancefromproviders();
    $cransi_type = isset($balance_response->currency) ? $balance_response->currency : 'LKR';

    if ($id) {


        // muaath update all
        if (isset($_SESSION['name_admin']) && $_SESSION['name_admin'] === 'muaath') {

            $stmt = $connect->prepare("UPDATE providers SET api_url=?, api_key=?, cransi_type=? WHERE id=?");
            $stmt->bind_param("sssi", $api_url, $api_key, $cransi_type, $id);
            $stmt->execute();
            $message = "Provider Updated!";

            $_SESSION['success'] = " Admin muaath access update all.";
            header("Location: providers.php"); // redirect பண்ணணும்
            exit();
        } else {
            // all admin update api_key onley
            $stmt = $connect->prepare("UPDATE providers SET  api_key=?,cransi_type=? WHERE id=?");
            $stmt->bind_param("ssi",  $api_key, $cransi_type, $id);
            $stmt->execute();
            $message = "Provider Updated!";
            $_SESSION['success'] = " Admin  access update Api key onley.";
            header("Location: providers.php"); // redirect பண்ணணும்
            exit();
        }
    } else {

        // new insert muaath onley
        if (!isset($_SESSION['name_admin']) || $_SESSION['name_admin'] !== 'muaath') {
            $_SESSION['error'] = " Unauthorized access. Only admin 'muaath' allowed.";
            header("Location: providers.php"); // redirect பண்ணணும்
            exit();
        }

        $stmt = $connect->prepare("INSERT INTO providers (api_url, api_key, cransi_type) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $api_url, $api_key, $cransi_type);
        $stmt->execute();
        $message = "Provider Added!";
    }

    header("Location: providers.php?msg=" . urlencode($message));
    exit();
}

// ✅ DELETE only if admin is 'muaath'
if (isset($_GET['delete'])) {
    if (!isset($_SESSION['name_admin']) || $_SESSION['name_admin'] !== 'muaath') {
        $_SESSION['error'] = " Unauthorized access. Only admin 'muaath' allowed.";
        header("Location: providers.php"); // redirect பண்ணணும்
        exit();
    }


    $deleteId = intval($_GET['delete']);
    $stmt = $connect->prepare("DELETE FROM providers WHERE id=?");
    $stmt->bind_param("i", $deleteId);
    $stmt->execute();
    header("Location: providers.php?msg=" . urlencode("Provider Deleted!"));
    exit();
}

// ✅ Load all providers
$providers = $connect->query("SELECT * FROM providers ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Provider Manager</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- trosted link -->

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <!-- trosted end -->

</head>

<body class="bg-light">


    <!-- trosted alrt -->
    <?php if (isset($_SESSION['success'])): ?>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                toastr.success("<?php echo addslashes($_SESSION['success']); ?>", "Success", {
                    closeButton: true,
                    progressBar: true,
                    positionClass: "toast-top-right",
                    timeOut: 3000,
                });
            });
        </script>
        <?php unset($_SESSION['success']); ?>
    <?php endif; ?>

    <?php if (isset($_SESSION['error'])): ?>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                toastr.error("<?php echo addslashes($_SESSION['error']); ?>", "Error", {
                    closeButton: true,
                    progressBar: true,
                    positionClass: "toast-top-right",
                    timeOut: 3000,
                });
            });
        </script>
        <?php unset($_SESSION['error']); ?>
    <?php endif; ?>

    <!-- trosted end -->

    <?php include 'include/header.php'; ?>

    <div class="container py-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4>Providers</h4>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#providerModal" onclick="clearProviderForm()">+ Add Provider</button>
        </div>

        <?php if (isset($_GET['msg'])): ?>
            <div class="alert alert-success text-center"><?= htmlspecialchars($_GET['msg']) ?></div>
        <?php endif; ?>

        <div class="table-responsive">
            <input type="text" id="searchInput" class="form-control mb-3" placeholder="🔍 Search Providers...">

            <table class="table table-bordered table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>API URL</th>
                        <th>API Key</th>
                        <th>Currency Type</th>
                        <th> Balance LKR </th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $providers->fetch_assoc()): ?>

                        <?php
                        // ஒவ்வொரு provider க்கும் balance எடுக்க  loop api 
                        $api = new Api($row['api_key'], $row['api_url']);
                        $balance_data = $api->balancefromproviders();
                        $balance_original = isset($balance_data->balance) ? floatval($balance_data->balance) : 0;
                        $from_currency = $row['cransi_type'];

                        // LKR conversion
                        $conversion_rate = getConversionRate($from_currency);
                        $balance_in_lkr = $balance_original * $conversion_rate;
                        ?>


                        <tr>
                            <td><?= $row['id'] ?></td>
                            <td><small><?= htmlspecialchars($row['api_url']) ?></small></td>
                            <td><small><?= substr($row['api_key'], 0, 10) ?>...</small></td>
                            <td><small><?= $row['cransi_type'] ?></small></td>
                            <td>
                                <span class="badge bg-success">
                                    <?= number_format($balance_in_lkr, 2) ?> LKR
                                </span>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#providerModal"
                                    onclick='editProvider(<?= json_encode($row) ?>)'>Edit</button>
                                <a href="?delete=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this provider?')">Delete</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Provider Modal -->
    <div class="modal fade" id="providerModal" tabindex="-1">
        <div class="modal-dialog">
            <form class="modal-content" method="POST">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">Provider Form</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="id" id="provider_id">

                    <div class="mb-3">
                        <label>API URL</label>
                        <input type="text" name="api_url" id="api_url" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label>API Key</label>
                        <input type="text" name="api_key" id="api_key" class="form-control" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success w-100">Save Provider</button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function editProvider(data) {
            document.getElementById('provider_id').value = data.id;
            document.getElementById('api_url').value = data.api_url;
            document.getElementById('api_key').value = data.api_key;
        }

        function clearProviderForm() {
            document.getElementById('provider_id').value = '';
            document.getElementById('api_url').value = '';
            document.getElementById('api_key').value = '';
        }
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $('#searchInput').on('input', function() {
            var value = $(this).val().toLowerCase();
            $("table tbody tr").filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
            });
        });
    </script>
</body>

</html>