<?php
include 'session.php';
include '../config/db.php';

// Fetch all referral commission records order by created_at DESC (latest first)
$sql = "
    SELECT 
        r.id AS refer_id,
        r.username AS refer_username,
        r.refer
    FROM users2 u
    JOIN users2 r ON u.refer_by = r.refer
    GROUP BY r.id, r.username, r.refer
    ORDER BY r.username
";
$result = $connect->query($sql);

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Referral Commissions</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>

<body>
    <?php include 'include/header.php'; ?>
    <div class="container py-5">
        <div class="card shadow-sm">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0">Referral History</h4>
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover text-center align-middle">
                        <thead class="table-dark">
                            <tr>
                                <th>#</th>
                                <th>Referrer Username</th>
                                <th>Referred Users</th>

                            </tr>
                        </thead>
                        <tbody>
                            <?php if ($result && $result->num_rows > 0): $i = 1; ?>
                                <?php while ($row = $result->fetch_assoc()): ?>
                                    <tr>
                                        <td><?php echo $row['refer_id']; ?></td>
                                        <td><?= htmlspecialchars($row['refer_username']) ?></td>
                                        <td>
                                            <button class="btn btn-sm btn-primary referer-btn"
                                                data-userid="<?= $row['refer_id'] ?>"
                                                data-username="<?= htmlspecialchars($row['refer_username']) ?>"
                                                data-refercode="<?= htmlspecialchars($row['refer']) ?>">
                                                View
                                            </button>
                                        </td>


                                    </tr>
                                <?php endwhile; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="4">No referral records found.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>

                    <!-- Modal -->
                    <div class="modal fade" id="refModal" tabindex="-1" role="dialog" aria-labelledby="refModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title fw-bold">Main Referred Users by <span class="text-primary" id="modalReferrerName"></span></h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body" id="modalReferredList">
                                    <!-- Referred usernames will be loaded here via AJAX -->
                                    <div class="text-center">Loading...</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <script>
                        document.querySelectorAll('.referer-btn').forEach(btn => {
                            btn.addEventListener('click', () => {
                                const referCode = btn.getAttribute('data-refercode');
                                const referName = btn.getAttribute('data-username');
                                document.getElementById('modalReferrerName').innerText = referName;

                                fetch('../public/ajx/get_referred_users.php?refer_code=' + referCode)
                                    .then(res => res.text())
                                    .then(data => {
                                        document.getElementById('modalReferredList').innerHTML = data;
                                    });

                                new bootstrap.Modal(document.getElementById('refModal')).show();
                            });
                        });
                    </script>


                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>