<?php
include 'session.php';
require("../config/db.php");

// Fetch existing referel setting (assuming one row only)
$result = $connect->query("SELECT * FROM referel LIMIT 1");
$data = $result->fetch_assoc();

$message = "";

// Form submit handling
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $referel_comisen = isset($_POST['referel_comisen']) ? (int)$_POST['referel_comisen'] : null;
    $refrel_status = isset($_POST['refrel_status']) ? (int)$_POST['refrel_status'] : null;

    if ($data) {
        // Update existing row
        $stmt = $connect->prepare("UPDATE referel SET referel_comisen = ?, refrel_status = ? WHERE id = ?");
        $stmt->bind_param("iii", $referel_comisen, $refrel_status, $data['id']);
        $stmt->execute();
        $message = "Referral settings updated successfully.";
    } else {
        // Insert new row
        $stmt = $connect->prepare("INSERT INTO referel (referel_comisen, refrel_status) VALUES (?, ?)");
        $stmt->bind_param("ii", $referel_comisen, $refrel_status);
        $stmt->execute();
        $message = "Referral settings saved successfully.";
    }

    header("Location: referel?msg=" . urlencode($message));
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>Referral Settings</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>

<body class="bg-light">
    <?php include 'include/header.php'; ?>

    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card shadow-lg rounded-3">
                    <div class="card-body">
                        <h3 class="mb-4 text-center">Referral Settings</h3>

                        <a href="refer_history" class="btn btn-success mb-3"> View Referral Commission History</a>

                        <a href="refer_users" class="btn btn-success mb-3"> View Referral History</a>


                        <?php if (isset($_GET['msg'])): ?>
                            <div class="alert alert-success text-center"><?= htmlspecialchars($_GET['msg']) ?></div>
                        <?php endif; ?>

                        <form method="post">
                            <div class="mb-3">
                                <label for="referel_comisen" class="form-label">Referral Commission (%)</label>
                                <input type="number" min="0" max="100" class="form-control" id="referel_comisen" name="referel_comisen"
                                    value="<?= htmlspecialchars($data['referel_comisen'] ?? '') ?>" required />
                            </div>
                            <div class="mb-3">
                                <label for="refrel_status" class="form-label">Referral Status</label>
                                <select class="form-select" id="refrel_status" name="refrel_status" required>
                                    <option value="1" <?= (isset($data['refrel_status']) && $data['refrel_status'] == 1) ? 'selected' : '' ?>>Active</option>
                                    <option value="0" <?= (isset($data['refrel_status']) && $data['refrel_status'] == 0) ? 'selected' : '' ?>>Inactive</option>
                                </select>
                            </div>
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">Save Settings</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>