<?php
include 'session.php';
include '../config/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $_SESSION['selected_provider_id'] = $_POST['provider_id'];
    header("Location: get_api_services");  // import.phpக்கு redirect
    exit();
}

$providers = $connect->query("SELECT id, api_url FROM providers ORDER BY provider_name ASC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<title>Select Provider</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<?php include 'include/header.php'; ?>
<div class="container py-5">
  <h3>Select a Provider</h3>
  <form method="POST">
    <div class="mb-3">
      <label for="provider_id" class="form-label">Provider</label>
      <select name="provider_id" id="provider_id" class="form-select" required>
        <option value="">-- Select Provider --</option>
        <?php while ($row = $providers->fetch_assoc()): ?>
          <option value="<?= htmlspecialchars($row['id']) ?>">
            <?= htmlspecialchars($row['api_url']) ?>
          </option>
        <?php endwhile; ?>
      </select>
    </div>
    <button type="submit" class="btn btn-primary">Select Provider</button>
  </form>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
