<?php
include '../config/db.php'; // DB connection file
include 'session.php';

$users = $connect->query("SELECT id, username FROM users2");
$services = $connect->query("SELECT id, service_name FROM services");
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Set Custom Price</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <!-- Select2 CSS -->
    <!-- jQuery (needed for Select2) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- Select2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>


</head>

<body>

    <?php include 'include/header.php'; ?>


    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-12 col-md-8 col-lg-6">
                <div class="card shadow-lg border-0 rounded-4">
                    <div class="card-header bg-primary text-white text-center rounded-top-4">
                        <h4 class="mb-0 fw-bold">🛠 Set Custom Price</h4>
                    </div>
                    <div class="card-body bg-light">
                        <form method="POST" action="custom_price_manager.php">
                            <!-- User Dropdown -->
                            <input type="hidden" name="action" value="add" />

                            <div class="mb-3">
                                <label for="addUser" class="form-label fw-semibold">👤 User</label>
                                <select name="user_id" id="addUser" class="form-select select2" required>
                                    <option value="">-- Select User --</option>
                                    <?php
                                    $users->data_seek(0);
                                    while ($u = $users->fetch_assoc()) { ?>
                                        <option value="<?= $u['id'] ?>">
                                            <?= htmlspecialchars($u['username']) ?> (ID: <?= $u['id'] ?>)
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>

                            <!-- Service Dropdown -->
                            <div class="mb-3">
                                <label for="addService" class="form-label fw-semibold">📦 Service</label>
                                <select name="service_id" id="addService" class="form-select select2" required>
                                    <option value="">-- Select Service --</option>
                                    <?php
                                    $services->data_seek(0);
                                    while ($s = $services->fetch_assoc()) { ?>
                                        <option value="<?= $s['id'] ?>">
                                            <?= htmlspecialchars($s['service_name']) ?> (ID: <?= $s['id'] ?>)
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>


                            <div class="mb-3">
                                <label class="form-label fw-semibold">💵 Custom Price (Rs)</label>
                                <input type="number" step="0.01" min="0" class="form-control shadow-sm" name="costome_price" placeholder="Eg: 49.00" required>
                            </div>

                            <div class="d-grid">
                                <button type="submit" class="btn btn-success fw-bold">
                                    💾 Save Price
                                </button>
                            </div>
                        </form>
                    </div>
                    <div class="card-footer text-center small text-muted">
                        Powered by Muaath 💡
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $('.select2').select2({
                placeholder: "🔍 Search here...",
                allowClear: true,
                width: '100%'
            });
        });
    </script>

<script>
$(document).ready(function () {
    $('.select2').select2({
        placeholder: "🔍 Search here...",
        allowClear: true,
        width: '100%'
    });

    // Service select change event
    $('#addService').change(function () {
        var serviceId = $(this).val();

        if (serviceId) {
            $.ajax({
                url: 'get_filles/get_default_price.php',
                type: 'GET',
                data: { service_id: serviceId },
                success: function (response) {
                    $('input[name="costome_price"]').val(response); // update price input
                }
            });
        } else {
            $('input[name="costome_price"]').val('');
        }
    });
});
</script>

    <!-- jQuery required for Select2 -->

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>