<?php
include 'session.php';
include '../config/db.php';

// Add
if (isset($_POST['add'])) {
    $bot_token = $_POST['bot_token'];
    $chat_id = $_POST['chat_id'];
    $status = $_POST['status'];

    $stmt = $connect->prepare("INSERT INTO telegram_bots (bot_token, chat_id, status) VALUES (?, ?, ?)");
    $stmt->bind_param("ssi", $bot_token, $chat_id, $status);
    $stmt->execute();
    $_SESSION['success'] = "✅ Telegram Bot Added!";
    header("Location: telegram_bots.php");
    exit;
}

// Update
if (isset($_POST['update'])) {
    $id = $_POST['id'];
    $bot_token = $_POST['bot_token'];
    $chat_id = $_POST['chat_id'];
    $status = $_POST['status'];

    $stmt = $connect->prepare("UPDATE telegram_bots SET bot_token=?, chat_id=?, status=? WHERE id=?");
    $stmt->bind_param("ssii", $bot_token, $chat_id, $status, $id);
    $stmt->execute();
    $_SESSION['success'] = "✅ Telegram Bot Updated!";
    header("Location: telegram_bots.php");
    exit;
}

// Delete
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $connect->prepare("DELETE FROM telegram_bots WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $_SESSION['success'] = "🗑️ Bot Deleted!";
    header("Location: telegram_bots.php");
    exit;
}

// Fetch
$bots = $connect->query("SELECT * FROM telegram_bots ORDER BY id DESC");
?>

<!DOCTYPE html>
<html>
<head>
    <title>Telegram Bots</title>
    <meta name="viewport" content="width=device-width, initial-scale=1"> <!-- Important for responsiveness -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <?php include 'include/header.php'; ?>
    <div class="container my-4">
        <h2 class="text-center mb-4">🤖 Telegram Bot Management</h2>

        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success"><?= $_SESSION['success']; unset($_SESSION['success']); ?></div>
        <?php endif; ?>

        <!-- Add Form -->
        <form method="POST" class="card p-4 mb-4 shadow-sm">
            <h5 class="mb-3">Add New Bot</h5>
            <div class="row g-3">
                <div class="col-12 col-md-4">
                    <input type="text" name="bot_token" class="form-control" placeholder="Bot Token" required>
                </div>
                <div class="col-12 col-md-4">
                    <input type="text" name="chat_id" class="form-control" placeholder="Chat ID" required>
                </div>
                <div class="col-6 col-md-2">
                    <select name="status" class="form-select" required>
                        <option value="0">🟥 Inactive</option>
                        <option value="1">🟩 Active</option>
                    </select>
                </div>
                <div class="col-6 col-md-2">
                    <button name="add" class="btn btn-success w-100">Add</button>
                </div>
            </div>
        </form>

        <!-- Bot Table -->
        <div class="card p-3 shadow-sm">
            <h5 class="mb-3">🔁 Existing Bots</h5>
            <div class="table-responsive">
                <table class="table table-bordered text-center align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th>ID</th>
                            <th>Token</th>
                            <th>Chat ID</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $modals = ''; while ($bot = $bots->fetch_assoc()): ?>
                        <tr>
                            <td><?= $bot['id'] ?></td>
                            <td><?= htmlspecialchars(substr($bot['bot_token'], 0, 15)) ?>...</td>
                            <td><?= htmlspecialchars($bot['chat_id']) ?></td>
                            <td><?= $bot['status'] ? '🟢 Active' : '🔴 Inactive' ?></td>
                            <td>
                                <button class="btn btn-sm btn-primary mb-1" data-bs-toggle="modal" data-bs-target="#edit<?= $bot['id'] ?>">Edit</button>
                                <a href="?delete=<?= $bot['id'] ?>" onclick="return confirm('Delete this bot?')" class="btn btn-sm btn-danger mb-1">Delete</a>
                            </td>
                        </tr>

                        <!-- Edit Modal -->
                        <?php ob_start(); ?>
                        <div class="modal fade" id="edit<?= $bot['id'] ?>" tabindex="-1">
                            <div class="modal-dialog modal-dialog-centered">
                                <form method="POST" class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Edit Bot</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>
                                    <div class="modal-body">
                                        <input type="hidden" name="id" value="<?= $bot['id'] ?>">
                                        <div class="mb-3">
                                            <label>Bot Token</label>
                                            <input type="text" name="bot_token" class="form-control" value="<?= htmlspecialchars($bot['bot_token']) ?>" required>
                                        </div>
                                        <div class="mb-3">
                                            <label>Chat ID</label>
                                            <input type="text" name="chat_id" class="form-control" value="<?= htmlspecialchars($bot['chat_id']) ?>" required>
                                        </div>
                                        <div class="mb-3">
                                            <label>Status</label>
                                            <select name="status" class="form-select">
                                                <option value="0" <?= ($bot['status'] == 0) ? 'selected' : '' ?>>🟥 Inactive</option>
                                                <option value="1" <?= ($bot['status'] == 1) ? 'selected' : '' ?>>🟩 Active</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button name="update" class="btn btn-primary">Update</button>
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <?php $modals .= ob_get_clean(); ?>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <?= $modals ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
