<?php
session_start();
include '../config/db.php';

$app = $_GET['app'] ?? '';
$user_id = $_SESSION['id'] ?? 0;



$user_currency = $_SESSION['currency_type'] ?? "LKR";


// neeed sarch
$_SESSION['catid'] = $app;

// Step 1: get commission percentage from users2
$com_query = $connect->prepare("SELECT comisen_parsentag FROM users2 WHERE id = ?");
$com_query->bind_param("i", $user_id);
$com_query->execute();
$com_result = $com_query->get_result();
$commission = 0;

if ($row = $com_result->fetch_assoc()) {
    $commission = floatval($row['comisen_parsentag']);
}


$query = $connect->prepare("
    SELECT 
        s.id, 
        s.service_name, 
        s.description, 
        -- fallback logic: if custom_quantity exists use it else fallback to service
        COALESCE(cq.min_quantity, s.min_quantity) AS min_quantity,
        COALESCE(cq.max_quantity, s.max_quantity) AS max_quantity,
        -- fallback logic: if custom_prices exists use it else fallback to service
        IF(cp.costome_price IS NOT NULL, cp.costome_price, s.price) AS price
    FROM services s
    LEFT JOIN custom_prices cp 
        ON s.id = cp.service_id AND cp.user_id = ?
    LEFT JOIN custom_quantity cq 
        ON s.id = cq.service_id AND cq.user_id = ?
    WHERE s.category_id = ? AND s.status = 'active'
    ORDER BY price ASC
");

$query->bind_param("iis", $user_id, $user_id, $app);
$query->execute();
$result = $query->get_result();

// $services = [];
// while ($row = $result->fetch_assoc()) {
//     $services[] = $row;
// }


$services = [];
while ($row = $result->fetch_assoc()) {
    $original_price = floatval($row['price']);
    $final_price = $original_price - ($original_price * $commission / 100); // add commission
    
       // 🔥 Convert price from LKR to USER CURRENCY (server-side)
$converted_price_user_currency = convertFromtoLKR($final_price, $user_currency);
    
    
    $row['price'] = round($final_price, 2); // round to 2 decimals
      $row['converted_price_user_currency'] = round($converted_price_user_currency, 2); // round to 2 decimals

    $services[] = $row;
}

echo json_encode($services);
