<?php
include '../config/db.php';
include 'api_class.php';



// class Api
// {
//     public $api_url;
//     public $api_key;

//     public function __construct($api_key, $api_url)
//     {
//         $this->api_key = $api_key;
//         $this->api_url = $api_url;
//     }

//     public function services()
//     {
//         return json_decode(
//             $this->connect([
//                 'key' => $this->api_key,
//                 'action' => 'services',
//             ])
//         );
//     }

//     private function connect($post)
//     {
//         $_post = [];
//         foreach ($post as $name => $value) {
//             $_post[] = $name . '=' . urlencode($value);
//         }

//         $ch = curl_init($this->api_url);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
//         curl_setopt($ch, CURLOPT_POST, 1);
//         curl_setopt($ch, CURLOPT_HEADER, 0);
//         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
//         curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
//         curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
//         curl_setopt($ch, CURLOPT_POSTFIELDS, join('&', $_post));
//         curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0');

//         $result = curl_exec($ch);
//         curl_close($ch);
//         return $result;
//     }
// }



// Prepare to cache currency conversion rates
$currencyRates = [];

// 1) Get all providers with their API details
$provider_query = $connect->query("SELECT id, api_key, api_url, cransi_type FROM providers");
if (!$provider_query) {
    die("DB Error: " . $connect->error);
}

while ($provider = $provider_query->fetch_assoc()) {
    $provider_id = $provider['id'];
    $api_key = $provider['api_key'];
    $api_url = $provider['api_url'];
    $currency_type = $provider['cransi_type'];




    if (!$api_key || !$api_url) continue;

    // Fetch currency conversion rate once per currency type
    if ($currency_type != 'LKR') {
        if (!isset($currencyRates[$currency_type])) {


            // DB-இருந்து rate_to_usd வாங்கு
            $sql1 = "SELECT rate_to_usd FROM currency_rates WHERE currency_code = '$currency_type' LIMIT 1";
            $res1 = mysqli_query($connect, $sql1);
            $row1 = mysqli_fetch_assoc($res1);

            // DB-இருந்து LKR rate வாங்கு
            $sql2 = "SELECT rate_to_usd FROM currency_rates WHERE currency_code = 'LKR' LIMIT 1";
            $res2 = mysqli_query($connect, $sql2);
            $row2 = mysqli_fetch_assoc($res2);

            if ($row1 && $row2) {
                // from_currency → USD மற்றும் LKR → USD
                $from_to_usd = (float)$row1['rate_to_usd'];
                $lkr_to_usd = (float)$row2['rate_to_usd'];

                // convert to LKR
                $currencyRates[$currency_type] = $from_to_usd / $lkr_to_usd;
            } else {
                // fallback
                $currencyRates[$currency_type] = 1;
            }
        }
        $rate_to_lkr = $currencyRates[$currency_type];
    } else {
        $rate_to_lkr = 1;
    }


    // Get services from API
    $api = new Api($api_key, $api_url);
    $api_services = $api->services();

    if (empty($api_services)) continue;

    // Map API services for quick lookup
    $api_services_map = [];
    foreach ($api_services as $service) {
        $api_services_map[$service->service] = $service;
    }

    // Get all local services for this provider
    $local_services = $connect->query("SELECT id, api_order_id FROM services WHERE provider_id = $provider_id");
    if (!$local_services) continue;

    // Prepare batch update cases valiyabel diklare
    $caseStatus = "";
    $caseProviderPrice = "";
    $caseProviderMin = ""; //  add this
    $caseProviderMax = ""; //  add this
    $ids = [];

    while ($local_service = $local_services->fetch_assoc()) {
        $service_id = $local_service['id'];
        $api_order_id = $local_service['api_order_id'];

        if (isset($api_services_map[$api_order_id])) {
            $status = 'active';
            $price = $api_services_map[$api_order_id]->rate;
            $provider_price = $price * $rate_to_lkr;

            // provider min max get
            $provider_min = isset($api_services_map[$api_order_id]->min) ? (int)$api_services_map[$api_order_id]->min : 0;
            $provider_max = isset($api_services_map[$api_order_id]->max) ? (int)$api_services_map[$api_order_id]->max : 0;
        } else {
            $status = 'inactive';
            $provider_price = 0;
            $provider_min = 0; // ✅ fix
            $provider_max = 0; // ✅ fix
        }

        $caseStatus .= " WHEN $service_id THEN '$status' ";
        $caseProviderPrice .= " WHEN $service_id THEN $provider_price ";

        $caseProviderMin .= " WHEN $service_id THEN $provider_min ";
        $caseProviderMax .= " WHEN $service_id THEN $provider_max ";


        $ids[] = $service_id;
    }

    if (!empty($ids)) {
        $ids_str = implode(',', $ids);
        $update_sql = "
    UPDATE services SET 
        status = CASE id $caseStatus END,
        provider_price = CASE id $caseProviderPrice END,
        provider_min = CASE id $caseProviderMin END,
        provider_max = CASE id $caseProviderMax END
    WHERE id IN ($ids_str)
";

        $connect->query($update_sql);
    }
}

header("Location: ../admin/index.php?msg=Service Status & Price Updated");
exit();
