<?php
include 'config/db.php';
include 'public/include/titlemg.php';

// 🔹 Stats
$total_users = $connect->query("SELECT COUNT(*) AS total FROM users2")->fetch_assoc()['total'] ?? 0;
$last_order = $connect->query("SELECT MAX(id) AS last_id FROM orders")->fetch_assoc()['last_id'] ?? 0;
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

<!-- seo -->

 <title><?= htmlspecialchars($sitename) ?> | Sri Lanka’s #1 SMM Panel | Buy Instagram, TikTok, YouTube & Facebook Services</title>

<meta name="description" content="Grow your brand with <?= htmlspecialchars($sitename) ?> — Sri Lanka’s #1 trusted SMM panel. Buy real Instagram followers, TikTok likes, YouTube views & more at the best prices.">
<meta name="keywords" content="smm panel sri lanka, best smm panel, buy instagram followers, tiktok likes, youtube views, facebook page likes, social media marketing sri lanka, rootsmm, rootmasterlk">

<meta name="author" content="<?= htmlspecialchars($sitename) ?>">
<meta name="robots" content="index, follow">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<!-- Open Graph / Facebook / Instagram -->
<meta property="og:site_name" content="<?= htmlspecialchars($sitename) ?>">
<meta property="og:title" content="<?= htmlspecialchars($sitename) ?> | Trusted SMM Panel in Sri Lanka">
<meta property="og:description" content="Get real engagement for Instagram, TikTok, YouTube & Facebook with <?= htmlspecialchars($sitename) ?>. Fast, affordable, and reliable SMM panel.">
<meta property="og:type" content="website">
<meta property="og:url" content="https://rootmasterlk.store">
<meta property="og:image" content="<?= htmlspecialchars($site_image) ?>">
<meta property="og:locale" content="en_US">

<!-- Twitter / X -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="<?= htmlspecialchars($sitename) ?> | SMM Panel Sri Lanka">
<meta name="twitter:description" content="Boost your reach & followers with <?= htmlspecialchars($sitename) ?>. Buy SMM services for Instagram, TikTok, YouTube & more.">
<meta name="twitter:image" content="<?= htmlspecialchars($site_image) ?>">
<meta name="twitter:creator" content="@<?= strtolower($sitename) ?>">

<!-- Canonical URL -->
<link rel="canonical" href="https://rootmasterlk.store">

<!-- Favicon -->
<link rel="icon" type="image/png" href="/assets/img/favicon.png">

<!-- Structured Data (Schema.org for SEO Rich Results) -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Organization",
  "name": "<?= htmlspecialchars($sitename) ?>",
  "url": "https://rootmasterlk.store",
  "logo": "<?= htmlspecialchars($site_image) ?>",
  "sameAs": [
    "https://www.facebook.com/rootmasterlk",
    "https://www.instagram.com/rootmasterlk",
    "https://www.tiktok.com/@rootmasterlk",
    "https://www.youtube.com/@rootmasterlk"
  ],
  "description": "<?= htmlspecialchars($sitename) ?> is Sri Lanka’s #1 SMM Panel offering real and fast services for Instagram, TikTok, YouTube & more."
}
</script>

<!-- seo -->

  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
  <style>
    body {
      background: #fff;
      color: #222;
      font-family: 'Poppins', sans-serif;
    }

    .hero {

      color: white;
      padding: 90px 20px;
      text-align: center;
    }

    .hero img {
      width: 120px;
      border-radius: 50%;
      margin-bottom: 20px;
      box-shadow: 0 0 15px rgba(255, 255, 255, 0.3);
    }

    .feature-box {
      background: #fff;
      border-radius: 15px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
      padding: 25px;
      transition: 0.3s;
      height: 100%;
    }

    .feature-box:hover {
      transform: translateY(-6px);
      box-shadow: 0 6px 18px rgba(0, 0, 0, 0.12);
    }

    .icon-circle {
      width: 55px;
      height: 55px;
      background: <?= $background_color ?>;
      color: #fff;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 15px;
      font-size: 22px;
    }

    .faq-section {
      background: #f9f9ff;
      padding: 60px 0;
    }
  </style>
</head>

<body>
  <?php include 'public/include/header.php'; ?>

  <!-- 🟣 Hero Section -->
  <section class="hero bg-custome">
    <img src="<?= htmlspecialchars($site_image) ?>" alt="Site Logo">
    <h1 class="fw-bold"><?= htmlspecialchars($header_name) ?></h1>
    <p class="lead"><?= htmlspecialchars($main_name) ?></p>
    <div class="mt-3">
      <a href="public/login" class="btn btn-light btn-lg me-2">Login</a>
      <a href="public/register" class="btn btn-outline-light btn-lg">Sign Up</a>
    </div>
  </section>

  <!-- 🔹 Features -->
  <div class="container my-5">
    <div class="row text-center g-4">
      <div class="col-md-3 col-sm-6">
        <div class="feature-box">
          <div class="icon-circle"><i class="fa-solid fa-star"></i></div>
          <h5>Prime Quality</h5>
          <p>Enjoy top SMM services at amazing prices!</p>
        </div>
      </div>
      <div class="col-md-3 col-sm-6">
        <div class="feature-box">
          <div class="icon-circle"><i class="fa-solid fa-bolt"></i></div>
          <h5>Super Fast</h5>
          <p>Orders start instantly and finish in minutes.</p>
        </div>
      </div>
      <div class="col-md-3 col-sm-6">
        <div class="feature-box">
          <div class="icon-circle"><i class="fa-solid fa-credit-card"></i></div>
          <h5>Payments</h5>
          <p>Add funds easily via local & global gateways.</p>
        </div>
      </div>
      <div class="col-md-3 col-sm-6">
        <div class="feature-box">
          <div class="icon-circle"><i class="fa-solid fa-headset"></i></div>
          <h5>Support</h5>
          <p>24/7 WhatsApp and ticket support available.</p>
        </div>
      </div>
    </div>
  </div>



  <!-- 🔹 Features -->
  <!-- 🔹 How it Works Section -->
  <section class="how-it-works py-5 text-center">
    <div class="container">
      <h2 class="fw-bold mb-5 text-dark">How it Works</h2>

      <div class="row justify-content-center g-4">
        <div class="col-lg-2 col-md-3 col-sm-6 col-12">
          <div class="feature-box work-step">
            <div class="icon-circle">
              <i class="fa-solid fa-user-plus"></i>
            </div>
            <p class="fw-semibold mt-3">Register & Login</p>
          </div>
        </div>

        <div class="col-lg-2 col-md-3 col-sm-6 col-12">
          <div class="feature-box work-step">
            <div class="icon-circle">
              <i class="fa-solid fa-wallet"></i>
            </div>
            <p class="fw-semibold mt-3">Add Funds</p>
          </div>
        </div>

        <div class="col-lg-2 col-md-3 col-sm-6 col-12">
          <div class="feature-box work-step">
            <div class="icon-circle">
              <i class="fa-solid fa-cart-shopping"></i>
            </div>
            <p class="fw-semibold mt-3">Place Orders</p>
          </div>
        </div>

        <div class="col-lg-2 col-md-3 col-sm-6 col-12">
          <div class="feature-box work-step">
            <div class="icon-circle">
              <i class="fa-solid fa-chart-line"></i>
            </div>
            <p class="fw-semibold mt-3">Get Results</p>
          </div>
        </div>
      </div>
    </div>
  </section>


  <!-- 🔹 Customer Reviews -->
  <section class="reviews-section py-5 text-center" style="background: <?= $background_color ?>; color:white;">
    <div class="container">
      <h2 class="fw-bold mb-5">Our Customers' Reviews</h2>

      <!-- Bootstrap Carousel -->
      <div id="reviewsCarousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="3000">
        <div class="carousel-inner">

          <?php
          $reviews = [
            ["name" => "Ahamed", "review" => "I've been using this SMM panel for months — fast delivery, friendly support and great prices. My clients love the speed!"],
            ["name" => "Aseena", "review" => "Very trusted service in Sri Lanka. Orders complete on time, and the WhatsApp support is really kind."],
            ["name" => "Sathees", "review" => "Perfect panel! Smooth UI, great rates and instant order update system. Highly recommended for local resellers."],
            ["name" => "Imran", "review" => "Reliable and consistent! I use this for my digital agency clients — no issues so far."],
            ["name" => "Priya", "review" => "User-friendly site and fast delivery. Love how they respond within minutes on WhatsApp!"],
            ["name" => "Tharindu", "review" => "Best SMM panel in Sri Lanka! My TikTok orders got delivered super fast and accurate."],
            ["name" => "Kavisha", "review" => "Superb experience! Payment process was easy and order tracking is simple. Highly professional."],
            ["name" => "Ramesh", "review" => "Affordable prices and real results. I’m fully satisfied with their Sri Lanka SMM panel service."],
            ["name" => "Dilani", "review" => "This panel made my Instagram page grow faster than I expected! Fast, secure, and easy to use."],
            ["name" => "Hashan", "review" => "Excellent service for resellers. Quick delivery and always 100% working. Keep it up guys!"]
          ];

          $active = 'active';
          foreach ($reviews as $r): ?>
            <div class="carousel-item <?= $active ?>">
              <div class="review-box bg-light text-dark p-4 rounded shadow-sm mx-auto" style="max-width:600px;">
                <i class="fa-solid fa-user-circle fa-2x mb-3 text-primary"></i>
                <h5 class="fw-bold"><?= htmlspecialchars($r['name']) ?></h5>
                <p class="fst-italic">“<?= htmlspecialchars($r['review']) ?>”</p>
              </div>
            </div>
          <?php
            $active = ''; // only first item active
          endforeach;
          ?>

        </div>

        <!-- Carousel Controls -->
        <button class="carousel-control-prev" type="button" data-bs-target="#reviewsCarousel" data-bs-slide="prev">
          <span class="carousel-control-prev-icon"></span>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#reviewsCarousel" data-bs-slide="next">
          <span class="carousel-control-next-icon"></span>
        </button>

      </div>
    </div>
  </section>
  <style>
    .reviews-section {
      background: <?= $background_color ?>;
      color: #fff;
    }

    .review-box {
      border: 2px solid transparent;
      background: #fff;
      color: #222;
      transition: all 0.4s ease;
    }

    .review-box:hover {
      transform: translateY(-5px);
      border-color: <?= $background_color ?>;
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
    }

    .review-box i {
      font-size: 45px;
      color: <?= $background_color ?>;
    }

    .carousel-control-prev-icon,
    .carousel-control-next-icon {
      filter: invert(1) grayscale(100%);
    }

    /* Mobile */
    @media (max-width: 576px) {
      .review-box {
        padding: 20px;
        font-size: 15px;
      }
    }
  </style>


  <!-- 🔹 FAQ -->
  <section class="faq-section">
    <div class="container">
      <h2 class="fw-bold text-center mb-5">Frequently Asked Questions</h2>
      <div class="accordion" id="faqAccordion">
        <?php
        $faqs = [
          ["What is an SMM panel?", "SMM panel is an automated platform to buy social media services like followers and likes."],
          ["Are your services safe?", "Yes, all our services are secure and tested before deployment."],
          ["How to add funds?", "You can use PayPal, Stripe, or local payment options."],
          ["Can I get instant support?", "Yes! Our support team is active 24/7."]
        ];
        foreach ($faqs as $index => $faq): ?>
          <div class="accordion-item">
            <h2 class="accordion-header" id="heading<?= $index ?>">
              <button class="accordion-button <?= $index > 0 ? 'collapsed' : '' ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?= $index ?>">
                <?= $faq[0] ?>
              </button>
            </h2>
            <div id="collapse<?= $index ?>" class="accordion-collapse collapse <?= $index == 0 ? 'show' : '' ?>" data-bs-parent="#faqAccordion">
              <div class="accordion-body"><?= $faq[1] ?></div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </section>

  <?php include 'public/include/footer.php'; ?>



  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>