

<?php
require('../../config/db.php');

if (!isset($_GET['refer_code'])) {
    echo "Invalid request.";
    exit;
}

$referCode = $_GET['refer_code'];



$sql = "SELECT username, id, comisen_parsentag, custome_ref FROM users2 WHERE refer_by = ?";
$stmt = $connect->prepare($sql);
$stmt->bind_param("s", $referCode);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
 while ($row = $result->fetch_assoc()) {
    $id = (int)$row['id'];
    $username = htmlspecialchars($row['username']);
    $commission = htmlspecialchars($row['comisen_parsentag']);
    $custome_ref = htmlspecialchars($row['custome_ref']);
?>
    <li class="list-group-item">
        <strong>Username : <?php echo $username; ?></strong>
        <form method="POST" action="more/update_commission.php" class="mt-2 d-flex align-items-center">
            <input type="hidden" name="id" value="<?php echo $id; ?>">
            <label class="me-2">Commission</label>
            <input type="number" name="commission" value="<?php echo $commission; ?>" step="0.01" class="form-control w-25 me-2" required>
            <label class="me-2">Custom Ref</label>
            <input type="number" name="custome_ref" value="<?php echo $custome_ref; ?>" step="1" class="form-control w-25 me-2">
            <button type="submit" class="btn btn-primary">Set</button>
        </form>
    </li>
<?php
}

} else {
    echo "<div class='text-muted'>No users referred by this person.</div>";
}


$stmt->close();
?>


