<?php
session_start();

header('Content-Type: application/json; charset=utf-8');

include '../../config/db.php';

$search = $_POST['search'] ?? '';
$searchTerm = "%$search%";




$user_currency = $_SESSION['currency_type'] ?? "LKR";


$user_id = $_SESSION['id'] ?? 0;

// ajex le save panne ctacry id edu 
$category = $_SESSION['catid'] ?? '';

// ✅ Use INNER JOIN instead of LEFT JOIN
$sql = "SELECT s.id AS service_id, s.service_name, s.category_id, c.category_name,  IF(cp.costome_price IS NOT NULL, cp.costome_price, s.price) AS price
        FROM services s
        INNER JOIN category c ON s.category_id = c.id
        LEFT JOIN custom_prices cp 
    ON cp.service_id = s.id 
    AND cp.user_id = ?
        LEFT JOIN hide_category hc 
            ON hc.category_id = s.category_id 
            AND hc.user_id = ?
        WHERE (s.service_name LIKE ? OR s.id LIKE ?)
          AND hc.category_id IS NULL
        LIMIT 10";
        
        

$stmt = $connect->prepare($sql);
if ($stmt === false) {
    echo json_encode(['status' => 'error', 'message' => $connect->error]);
    exit;
}




$stmt->bind_param("siss", $user_id, $user_id, $searchTerm, $searchTerm);

$stmt->execute();

$result = $stmt->get_result();

$data = [];
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        
        
          $lkr_price = (float)$row['price'];

    // Convert to user currency
    $converted = convertFromtoLKR($lkr_price, $user_currency);
    // 6 decimals force
$converted = round($converted, 6);

    $row['price_lkr'] = $lkr_price;
    $row['converted_price'] = $converted;
        
        $data[] = $row; // category_name will never be null now
    }
    echo json_encode(['status' => 'success', 'data' => $data,  'category' => $category]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'No matching services found.']);
}

$stmt->close();
$connect->close();
