<?php
include '../../config/db.php';

// 1) Get extraprofit % from settings table
$setting_res = mysqli_query($connect, "SELECT extraprofit FROM setting LIMIT 1");
$extraProfitPercent = 0;
if ($setting_res && mysqli_num_rows($setting_res) > 0) {
    $setting_row = mysqli_fetch_assoc($setting_res);
    $extraProfitPercent = (float)$setting_row['extraprofit'];
}

// 2) Select services where provider_price IS NULL OR 0 only
$services_res = mysqli_query($connect, "SELECT id, provider_price, price FROM services WHERE provider_price > price");
if (!$services_res) {
    die("Failed to fetch services: " . mysqli_error($connect));
}

while ($service = mysqli_fetch_assoc($services_res)) {
    $service_id = $service['id'];
    $provider_price = (float)$service['provider_price'];

    // Calculate final price with extra profit %
    $final_price = $provider_price + ($provider_price * $extraProfitPercent / 100);

    // Update only if final_price > 0
    if ($final_price > 0) {
        $final_price_escaped = mysqli_real_escape_string($connect, $final_price);
        $update_sql = "UPDATE services SET price = $final_price_escaped WHERE id = $service_id";
        mysqli_query($connect, $update_sql);
    }
}

header("Location: ../../admin/dashboard");
exit;
?>
