<?php



function getConversionRate($from_currency)
{
    include '../config/db.php'; // இதில் $connect இருக்கணும்
    // 💡 உங்க db.php-ல் $connect = mysqli_connect(...) இருக்க வேண்டும்

    $from_currency = strtoupper($from_currency);

    // base தான் LKRனா 1 return பண்ணிடு
    if ($from_currency == 'LKR') {
        return 1;
    }

    // from_currency → USD
    $sql1 = "SELECT rate_to_usd FROM currency_rates WHERE currency_code = '$from_currency' LIMIT 1";
    $res1 = mysqli_query($connect, $sql1);
    if (!$res1 || mysqli_num_rows($res1) == 0) {
        return 1; // fallback
    }
    $row1 = mysqli_fetch_assoc($res1);
    $from_to_usd = (float)$row1['rate_to_usd'];

    // LKR → USD
    $sql2 = "SELECT rate_to_usd FROM currency_rates WHERE currency_code = 'LKR' LIMIT 1";
    $res2 = mysqli_query($connect, $sql2);
    if (!$res2 || mysqli_num_rows($res2) == 0) {
        return 1; // fallback
    }
    $row2 = mysqli_fetch_assoc($res2);
    $lkr_to_usd = (float)$row2['rate_to_usd'];

    // USD → LKR
    $usd_to_lkr = 1 / $lkr_to_usd;

    // from_currency → LKR
    $final_rate = $from_to_usd * $usd_to_lkr;

    return $final_rate;
}

