<?php
$query = "SELECT message FROM popup_messages ORDER BY id DESC LIMIT 1";
$result = mysqli_query($connect, $query);
$row = mysqli_fetch_assoc($result);
$popupMessage = trim($row['message'] ?? '');
$showPopup = !empty($popupMessage); // popup only if message exists
?>


<!-- SweetAlert2 CDN -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
  document.addEventListener("DOMContentLoaded", function () {
    <?php if ($showPopup): ?>
      if (!sessionStorage.getItem("sessionPopupShown")) {
        Swal.fire({
          title: '📢 Message',
          html: <?= json_encode($popupMessage) ?>, // use html: instead of text:
          icon: 'info',
          confirmButtonText: 'OK',
          confirmButtonColor: '#28a745',
          background: '#f8f9fa'
        });
        sessionStorage.setItem("sessionPopupShown", "true");
      }
    <?php endif; ?>
  });
</script>



