<?php
// Database connection setup
include '../../config/db.php';




if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $text = $_GET['text'] ?? '';



    if (!empty($text)) {
        // Case 1: eZ Cash SMS format
        if (preg_match('/Received from (\d+)\s+(\d{2}\/\d{2}\/\d{4}\s+\d{2}:\d{2})\s+Rs\.([\d.]+).*?Service Charge: Rs\.([\d.]+).*?Net Received: Rs\.([\d.]+).*?RN:(\d+)/', $text, $matches)) {
            $received_from = $matches[1];
            $date = $matches[2];
            $amount = $matches[3];
            $charge = $matches[4];
            $net_received = $matches[5];
            $rn_number = $matches[6];

            // Insert into ez_payment
            $stmt = $connect->prepare("INSERT INTO ez_payment (rn_number, amount, charge, date, received_from, net_received) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("iddssd", $rn_number, $amount, $charge, $date, $received_from, $net_received);

            if ($stmt->execute()) {
                echo " eZ Cash SMS saved to ez_payment.";
            } else {
                echo " DB Error (eZ Cash): " . $stmt->error;
            }
            $stmt->close();

            // Case 2: BOC SMS format
            // } elseif (preg_match('/Transfer Credit\s+Rs\.?\s*([\d.]+)/i', $text, $bocMatch)) {
            //     $bocAmount = $bocMatch[1];

            //     // Insert into boc table
            //     $stmt = $connect->prepare("INSERT INTO boc (amount) VALUES (?)");
            //     $stmt->bind_param("d", $bocAmount);

            //     if ($stmt->execute()) {
            //         echo " BOC SMS saved to boc.";
            //     } else {
            //         echo " DB Error (BOC): " . $stmt->error;
            //     }
            //     $stmt->close();
            // 
        } else {
            echo " Format mismatch. SMS not recognized.";
        }
    } else {
        echo " Empty SMS.";
    }
} else {
    http_response_code(405);
    echo "405 - Method Not Allowed";
}

$connect->close();
