<?php
session_start();
?>


<?php 

require("../config/db.php");
include 'include/titlemg.php'; 
include 'include/header.php'; 
?>

<!DOCTYPE html>
<html lang="en">
<head>
      <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"> <!-- Responsive meta -->
    <meta name="description" content="Terms and Policy of <?= htmlspecialchars($sitename) ?> SMM Panel">
    <meta name="keywords" content="terms, policy, smm panel, instagram, tiktok, youtube, <?= htmlspecialchars($sitename) ?>">
    <meta name="author" content="<?= htmlspecialchars($sitename) ?>">

    <title>Terms & Policy - <?= htmlspecialchars($sitename) ?></title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">


    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
   background: #ffffff !important;            
            color: #fff;
            font-family: Arial, sans-serif;
        }
        .terms-box {
          
            margin: auto;
            background: rgba(255,255,255,0.12);
            border-radius: 15px;
            padding: 35px;
            backdrop-filter: blur(7px);
        }
     
    </style>
</head>

<body>

<div class="container">


   <div class="terms-box bg-custome mt-3 mb-3 p-4">

    <div class="text-center mb-4">
        <img src="<?= htmlspecialchars($site_image) ?>" alt="<?= htmlspecialchars($sitename) ?>" 
             style="max-width:120px; border-radius:10px;">
        <h1 class="mt-3"><i class="fas fa-file-contract me-2 text-primary"></i> Terms & Conditions</h1>
        <p class="lead"><i class="fas fa-info-circle me-2 text-secondary"></i> For <?= htmlspecialchars($sitename) ?> SMM Panel</p>
    </div>

    <p><i class="fas fa-angle-right me-2 text-dark"></i>
        The use of services provided by <b><?= htmlspecialchars($sitename) ?></b> establishes agreement to the following terms.
        By registering or using our services, you confirm that you have fully read and accepted these terms.
        We will not be held liable for any loss caused by ignoring these terms.
    </p>

    <h2 class="mt-4"><i class="fas fa-truck me-2 text-success"></i> Delivery Policy</h2>
    <ul>
        <li><i class="fas fa-check-circle me-2 text-success"></i> By placing an order, you automatically accept all terms listed here.</li>
        <li><i class="fas fa-check-circle me-2 text-success"></i> Terms may change anytime without notice – customers must check before ordering.</li>
        <li><i class="fas fa-check-circle me-2 text-success"></i> You must follow Instagram, YouTube, Facebook, TikTok and other platform policies.</li>
        <li><i class="fas fa-check-circle me-2 text-success"></i> Rates may change anytime without notice.</li>
        <li><i class="fas fa-check-circle me-2 text-success"></i> No guaranteed delivery time for any service; depends on system load.</li>
        <li><i class="fas fa-check-circle me-2 text-success"></i> We may adjust service type if needed to complete the order.</li>
        <li><i class="fas fa-check-circle me-2 text-success"></i> Drop ratio or “Non Drop” guarantee may change after social media updates.</li>
    </ul>

    <h2 class="mt-4"><i class="fas fa-exclamation-triangle me-2 text-warning"></i> Disclaimer</h2>
    <p><i class="fas fa-info-circle me-2 text-dark"></i> <?= htmlspecialchars($sitename) ?> will not be responsible for any business or personal damages.</p>

    <h2 class="mt-4"><i class="fas fa-shield-alt me-2 text-danger"></i> Liabilities</h2>
    <p><i class="fas fa-info-circle me-2 text-dark"></i> We are not responsible for suspension, deletion or restriction by Instagram/YouTube/Twitter/Facebook or any other platform.</p>

    <h2 class="mt-4"><i class="fas fa-user-secret me-2 text-info"></i> Privacy Policy</h2>
    <ul>
        <li><i class="fas fa-lock me-2 text-info"></i> Your data is used only to complete orders.</li>
        <li><i class="fas fa-lock me-2 text-info"></i> We never sell or share your personal information.</li>
        <li><i class="fas fa-lock me-2 text-info"></i> Data stored securely with encryption.</li>
    </ul>

    <h2 class="mt-4"><i class="fas fa-hand-holding-dollar me-2 text-warning"></i> Refund Policy</h2>
    <ul>
        <li><i class="fas fa-ban me-2 text-warning"></i> No refund to payment methods after deposit.</li>
        <li><i class="fas fa-money-bill-wave me-2 text-warning"></i> Balance must be used for panel orders only.</li>
        <li><i class="fas fa-exclamation-triangle me-2 text-warning"></i> Chargeback or disputes → account termination + service removal.</li>
        <li><i class="fas fa-times-circle me-2 text-warning"></i> Orders cannot be cancelled after placing.</li>
        <li><i class="fas fa-sync me-2 text-warning"></i> If non-deliverable → refund added to panel balance only.</li>
        <li><i class="fas fa-user-slash me-2 text-warning"></i> Private account or wrong link orders are not refundable.</li>
        <li><i class="fas fa-user-times me-2 text-warning"></i> Fraud = permanent ban.</li>
        <li><i class="fas fa-exclamation-circle me-2 text-warning"></i> Don’t use two servers for the same link simultaneously.</li>
    </ul>

    <h2 class="mt-4"><i class="fas fa-info-circle me-2 text-primary"></i> About Services</h2>
    <ul>
        <li><i class="fas fa-star me-2 text-primary"></i> Services are for boosting appearance only.</li>
        <li><i class="fas fa-star me-2 text-primary"></i> No guarantee of engagement or interactions.</li>
        <li><i class="fas fa-star me-2 text-primary"></i> Not all accounts may have profile picture, bio or posts.</li>
        <li><i class="fas fa-star me-2 text-primary"></i> No nudity or prohibited content allowed.</li>
        <li><i class="fas fa-star me-2 text-primary"></i> For pages that already had 100k+ followers, refill may not apply.</li>
    </ul>

    <p class="mt-4 text-center">
        <i class="fas fa-copyright me-2 text-secondary"></i> © <?= date("Y") ?> <?= htmlspecialchars($sitename) ?> — All Rights Reserved.
    </p>

</div>

</div>
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
   <?php include 'include/whatsapp.php'; ?>
    <?php include 'include/footer.php'; ?>

</body>
</html>
