<?php
require("../config/db.php");
include 'include/titlemg.php';

session_start();

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $entered_otp = $_POST['otp'];
    if ($entered_otp == $_SESSION['otp']) {
        $_SESSION['reset_email'] = $_SESSION['otp_email'];
        unset($_SESSION['otp']);
        unset($_SESSION['otp_email']);
        header("Location: reset_password?token=verified");
        exit();
    } else {
        $error = "Invalid OTP!";
    }
}
?>


<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Verify OTP</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>

<body class="container  d-flex align-items-center justify-content-center" style="min-height: 100vh;">

  <div class="card p-4 shadow" style="max-width: 400px; width: 100%;">
    <h3 class="text-center text-primary fw-bold mb-4">Enter OTP</h3>

    <?php if (isset($error)) : ?>
      <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= htmlspecialchars($error) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
      </div>
    <?php endif; ?>

    <form method="post" novalidate>
      <div class="mb-3">
        <label for="otp" class="form-label fw-semibold">OTP</label>
        <input type="text" id="otp" name="otp" class="form-control form-control-lg" placeholder="Enter your OTP" required />
      </div>

      <button type="submit" name="submit" class="btn btn-success btn-lg w-100 fw-semibold">Verify</button>
    </form>

    <p class="text-center mt-3">
      <a href="login" class="text-decoration-none fw-semibold text-primary">&larr; Back to Login</a>
    </p>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
