<?php
include 'config/db.php';
include 'public/include/titlemg.php';

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">


<title>API Documentation | <?= htmlspecialchars($sitename) ?> | Developer Integration Guide</title>

<meta name="description" content="Integrate <?= htmlspecialchars($sitename) ?> SMM services using our powerful API. Automate orders for Instagram followers, TikTok likes, and YouTube views with easy API documentation.">
<meta name="keywords" content="api documentation, smm panel api, smm api integration, developer api, social media marketing api, instagram api, tiktok api, youtube api, rootsmm, rootmasterlk">

<meta name="robots" content="index, follow">
<meta name="author" content="<?= htmlspecialchars($sitename) ?>">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<!-- Open Graph / Facebook / Instagram -->
<meta property="og:title" content="API Documentation | <?= htmlspecialchars($sitename) ?> Developer Guide">
<meta property="og:description" content="Access <?= htmlspecialchars($sitename) ?>’s full API documentation to automate your social media orders. Easy, secure, and fast integration for developers.">
<meta property="og:type" content="website">
<meta property="og:url" content="https://rootmasterlk.store/api">
<meta property="og:image" content="<?= htmlspecialchars($site_image) ?>">
<meta property="og:site_name" content="<?= htmlspecialchars($sitename) ?>">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="API Documentation | <?= htmlspecialchars($sitename) ?>">
<meta name="twitter:description" content="Integrate <?= htmlspecialchars($sitename) ?>’s API to automate Instagram, TikTok, and YouTube SMM orders. Complete API documentation for developers.">
<meta name="twitter:image" content="<?= htmlspecialchars($site_image) ?>">

<!-- Canonical -->
<link rel="canonical" href="https://rootmasterlk.store/api">

<!-- JSON-LD Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "TechArticle",
  "name": "API Documentation - <?= htmlspecialchars($sitename) ?>",
  "headline": "API Integration Guide for <?= htmlspecialchars($sitename) ?>",
  "url": "https://rootmasterlk.store/api",
  "description": "Read <?= htmlspecialchars($sitename) ?> API documentation to integrate SMM services such as Instagram followers, TikTok likes, and YouTube views easily.",
  "publisher": {
    "@type": "Organization",
    "name": "<?= htmlspecialchars($sitename) ?>",
    "logo": "<?= htmlspecialchars($site_image) ?>"
  },
  "author": {
    "@type": "Organization",
    "name": "<?= htmlspecialchars($sitename) ?>"
  }
}
</script>








    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background-color: #f7f6fb;
            font-family: 'Poppins', sans-serif;
        }

        .api-card {
            background: #fff;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
            margin-bottom: 40px;
        }

        .api-title {
            color: #4a00e0;
            font-weight: 700;
            border-left: 6px solid #6c63ff;
            padding-left: 10px;
            margin-bottom: 20px;
        }

        .table th {
            background-color: #6c63ff;
            color: #fff;
            text-transform: uppercase;
        }

        pre {
            background: #f5f0ff;
            padding: 20px;
            border-radius: 10px;
            overflow-x: auto;
            font-size: 0.9rem;
        }

        code {
            color: #3f3fff;
        }

        .btn-sample {
            background: linear-gradient(135deg, #6c63ff, #3f3fff);
            color: white;
            border-radius: 10px;
            font-weight: 600;
            padding: 10px 25px;
            transition: 0.3s;
        }

        .btn-sample:hover {
            opacity: 0.85;
        }
    </style>
</head>

<body>
    <?php include 'public/include/header.php'; ?>

    <div class="container my-5">
        <div class="api-card">
            <h2 class="api-title"><i class="bi bi-plug-fill me-2"></i>API Integration</h2>

            <div class="row g-3">
                <div class="col-md-6">
                    <p><strong>HTTP Method:</strong> <span class="text-primary">POST</span></p>
                    <p><strong>API URL:</strong> <code>https://<?php echo $_SERVER['HTTP_HOST']; ?>/api/v2</code></p>
                </div>
                <div class="col-md-6">
                    <p><strong>API Key:</strong> Get it from your <a href="my_account" class="text-decoration-none text-primary">Account</a> page</p>
                    <p><strong>Return Format:</strong> JSON</p>
                </div>
            </div>
        </div>

        <!-- Service List -->
        <div class="api-card">
            <h4 class="api-title">Service List</h4>
            <table class="table table-bordered align-middle text-center">
                <thead>
                    <tr>
                        <th>Parameter</th>
                        <th>Explanation</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><code>key</code></td>
                        <td>Your API key</td>
                    </tr>
                    <tr>
                        <td><code>action</code></td>
                        <td><code>services</code></td>
                    </tr>
                </tbody>
            </table>

            <h6 class="fw-bold mt-4 text-secondary">Sample Response:</h6>
            <pre>[
  {
    "service": 1,
    "name": "Followers",
    "type": "Default",
    "category": "Instagram Growth",
    "rate": "0.80",
    "min": "100",
    "max": "10000"
  },
  {
    "service": 2,
    "name": "Likes",
    "type": "High Quality",
    "category": "Instagram Likes",
    "rate": "0.50",
    "min": "50",
    "max": "10000"
  }
]</pre>
        </div>

        <!-- New Order -->
        <div class="api-card">
            <h4 class="api-title">Create New Order</h4>
            <table class="table table-bordered align-middle text-center">
                <thead>
                    <tr>
                        <th>Parameter</th>
                        <th>Explanation</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><code>key</code></td>
                        <td>Your API Key</td>
                    </tr>
                    <tr>
                        <td><code>action</code></td>
                        <td><code>add</code></td>
                    </tr>
                    <tr>
                        <td><code>service</code></td>
                        <td>Service ID</td>
                    </tr>
                    <tr>
                        <td><code>link</code></td>
                        <td>Post / Video / Channel URL</td>
                    </tr>
                    <tr>
                        <td><code>quantity</code></td>
                        <td>Amount to order</td>
                    </tr>
                </tbody>
            </table>
            <h6 class="fw-bold text-secondary mt-4">Sample Response:</h6>
            <pre>{
  "order": 12345
}</pre>
        </div>

        <!-- Order Status -->
        <div class="api-card">
            <h4 class="api-title">Order Status</h4>
            <table class="table table-bordered align-middle text-center">
                <thead>
                    <tr>
                        <th>Parameter</th>
                        <th>Explanation</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><code>key</code></td>
                        <td>Your API Key</td>
                    </tr>
                    <tr>
                        <td><code>action</code></td>
                        <td><code>status</code></td>
                    </tr>
                    <tr>
                        <td><code>order</code></td>
                        <td>Order ID</td>
                    </tr>
                </tbody>
            </table>
            <pre>{
  "charge": "0.27819",
  "start_count": "3572",
  "status": "Partial",
  "remains": "157",
  "currency": "USD"
}</pre>
        </div>

        <!-- User Balance -->
        <div class="api-card">
            <h4 class="api-title">User Balance</h4>
            <table class="table table-bordered align-middle text-center">
                <thead>
                    <tr>
                        <th>Parameter</th>
                        <th>Explanation</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><code>key</code></td>
                        <td>Your API Key</td>
                    </tr>
                    <tr>
                        <td><code>action</code></td>
                        <td><code>balance</code></td>
                    </tr>
                </tbody>
            </table>

            <h6 class="fw-bold text-secondary mt-4">Sample Response:</h6>
            <pre>{
  "balance": "100.8429",
  "currency": "LKR"
}</pre>

            <div class="text-center mt-3">
                <a href="public/sample_api.txt" class="btn btn-sample"><i class="bi bi-file-earmark-code-fill me-2"></i>Download Sample PHP File</a>
            </div>
        </div>
    </div>

    <?php include 'public/include/footer.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>