<?php
include 'config/db.php';
include 'public/include/titlemg.php';
session_start();

// ✅ Get user ID (from session or cookie)
if (!isset($_SESSION['id']) && isset($_COOKIE['user_id'])) {
    $_SESSION['id'] = $_COOKIE['user_id'];
}
$user_id = $_SESSION['id'] ?? 0;

// ✅ Pagination setup
$limit = 30;
$page = isset($_GET['page']) && $_GET['page'] > 0 ? intval($_GET['page']) : 1;
$offset = ($page - 1) * $limit;

// ✅ Search filter
$search = isset($_GET['search']) ? trim($_GET['search']) : "";

// ✅ Base SQL — same for both cases (login / guest)
$sql = "
SELECT 
    c.id AS category_id, 
    c.category_name,
    s.id AS service_id,
    s.service_name,
    s.description,
    COALESCE(cq.min_quantity, s.min_quantity) AS min_quantity,
    COALESCE(cq.max_quantity, s.max_quantity) AS max_quantity,
    IF(cp.costome_price IS NOT NULL, cp.costome_price, s.price) AS price
FROM category c
JOIN services s ON s.category_id = c.id
";

// ✅ Only if user is logged in, join custom tables & hide_category
if ($user_id > 0) {
    $sql .= "
    LEFT JOIN custom_prices cp ON s.id = cp.service_id AND cp.user_id = ?
    LEFT JOIN custom_quantity cq ON s.id = cq.service_id AND cq.user_id = ?
    LEFT JOIN hide_category hc ON hc.category_id = s.category_id AND hc.user_id = ?
    WHERE s.status = 'active' AND hc.category_id IS NULL
    ";
} else {
    // ✅ Guest user (no login)
    $sql .= "
    LEFT JOIN custom_prices cp ON s.id = cp.service_id AND 0
    LEFT JOIN custom_quantity cq ON s.id = cq.service_id AND 0
    WHERE s.status = 'active'
    ";
}

// ✅ Search filter
if ($search !== "") {
    $sql .= " AND s.service_name LIKE ?";
}

// ✅ Order + Limit
$sql .= " ORDER BY c.in_order ASC, s.price ASC LIMIT ? OFFSET ?";

// ✅ Prepare statement
$stmt = $connect->prepare($sql);

if (!$stmt) {
    die("SQL Error: " . $connect->error);
}

// ✅ Bind parameters
if ($user_id > 0 && $search !== "") {
    $like = "%$search%";
    $stmt->bind_param("iiisii", $user_id, $user_id, $user_id, $like, $limit, $offset);
} elseif ($user_id > 0) {
    $stmt->bind_param("iiiii", $user_id, $user_id, $user_id, $limit, $offset);
} elseif ($search !== "") {
    $like = "%$search%";
    $stmt->bind_param("sii", $like, $limit, $offset);
} else {
    $stmt->bind_param("ii", $limit, $offset);
}

$stmt->execute();
$result = $stmt->get_result();

$categories = [];
while ($row = $result->fetch_assoc()) {
    $categories[$row['category_name']][] = $row;
}


$count_sql = "SELECT COUNT(*) AS total FROM services WHERE status = 'active'";
$count_result = $connect->query($count_sql);
$total_rows = $count_result->fetch_assoc()['total'];


$total_pages = ceil($total_rows / $limit);









// Load all currencies for dropdown
$allcurrencies = $connect->query("SELECT currency_code FROM currency_rates ORDER BY currency_code ASC");





?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- seo -->


    <title>Services List | <?= htmlspecialchars($sitename) ?> | Buy Instagram, TikTok, YouTube & Facebook SMM Services</title>

    <meta name="description" content="Explore all SMM services on <?= htmlspecialchars($sitename) ?> — buy Instagram followers, TikTok likes, YouTube views, and Facebook engagement at the best prices in Sri Lanka.">
    <meta name="keywords" content="services list, smm panel sri lanka, instagram followers, tiktok likes, youtube views, facebook page likes, social media marketing, rootsmm, rootmasterlk">

    <meta name="robots" content="index, follow">
    <meta name="author" content="<?= htmlspecialchars($sitename) ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Open Graph / Facebook / Instagram -->
    <meta property="og:title" content="Services List | <?= htmlspecialchars($sitename) ?>">
    <meta property="og:description" content="Check out the full list of SMM services from <?= htmlspecialchars($sitename) ?>. Grow your Instagram, TikTok, and YouTube with trusted providers.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://rootmasterlk.store/services">
    <meta property="og:image" content="<?= htmlspecialchars($site_image) ?>">
    <meta property="og:site_name" content="<?= htmlspecialchars($sitename) ?>">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Services List | <?= htmlspecialchars($sitename) ?>">
    <meta name="twitter:description" content="View all social media marketing services available on <?= htmlspecialchars($sitename) ?> — Instagram, TikTok, YouTube, and more.">
    <meta name="twitter:image" content="<?= htmlspecialchars($site_image) ?>">

    <!-- Canonical -->
    <link rel="canonical" href="https://rootmasterlk.store/services">

    <!-- JSON-LD Schema -->
    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "WebPage",
            "name": "Services List - <?= htmlspecialchars($sitename) ?>",
            "url": "https://rootmasterlk.store/services",
            "description": "Browse the complete services list from <?= htmlspecialchars($sitename) ?>. Buy Instagram, TikTok, and YouTube SMM services fast and securely.",
            "publisher": {
                "@type": "Organization",
                "name": "<?= htmlspecialchars($sitename) ?>",
                "logo": "<?= htmlspecialchars($site_image) ?>"
            }
        }
    </script>

    <!-- 
    seo -->

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background: #f5f4fa;
            font-family: 'Poppins', sans-serif;
        }

        .category-header {
            background: #eae8ff;
            color: #4a00e0;
            font-weight: bold;
            padding: 10px 15px;
            border-radius: 8px;
            margin-top: 30px;
            box-shadow: inset 0 0 5px rgba(0, 0, 0, 0.1);
        }

        table {
            background: #fff;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
        }

        th {
            background-color: #6c63ff;
            color: white;
            text-align: center;
        }

        td {
            vertical-align: middle;
        }

        .price-tag {
            font-weight: 600;
            color: #008000;
        }

        .btn-view {
            background: #6c63ff;
            color: white;
            border-radius: 20px;
        }

        .btn-cart {
            background: #00aaff;
            color: white;
            border-radius: 50%;
            padding: 8px 10px;
        }

        .btn-cart:hover,
        .btn-view:hover {
            opacity: 0.8;
        }
    </style>
</head>

<body>

    <?php
    
    include 'public/include/header.php'; 
    
    
    
    

if ($logged_in) {

   

} elseif (isset($_POST['change_currency'])) {
    
        unset($_SESSION['currency_type']);

    $_SESSION['currency_type'] = $_POST['change_currency'];
    $user_currency = $_POST['change_currency'];

} else {

    if (isset($_SESSION['currency_type'])) {
        $user_currency = $_SESSION['currency_type'];
    }
}

 $user_currency = $_SESSION['currency_type'] ?? "LKR";    
    
    // =============================
//  Fetch Currency SYMBOL
// =============================
$currency_symbol = $user_currency;

$symbol_q = $connect->query("
    SELECT currency_symbol 
    FROM currency_rates 
    WHERE currency_code = '$user_currency'
    LIMIT 1
");

if ($symbol_q && $symbol_q->num_rows > 0) {
    $symbol_row = $symbol_q->fetch_assoc();
    $currency_symbol = $symbol_row['currency_symbol'] ?? $user_currency;
}

$_SESSION['currency_symbol'] = $currency_symbol;
    
    ?>

    <div class="container my-5">
        <h2 class="fw-bold mb-4 text-center text-primary"><i class="bi bi-layers-fill"></i> Services & Pricing</h2>

        <!-- 🔍 Search Box -->
        <form class="mb-4" method="GET" action="">
            <div class="input-group">
                <input type="text" name="search" class="form-control form-control-lg"
                    placeholder="Search for a service..."
                    value="<?= htmlspecialchars($search) ?>">
                <button class="btn btn-primary btn-lg" type="submit"><i class="bi bi-search"></i> Search</button>
            </div>
        </form>
        
        <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

        
<?php if (!$logged_in): ?>
<form method="POST" class="mb-3 text-center">

    <label for="currency_select" class="fw-semibold me-2">
        <i class="bi bi-currency-exchange text-success me-1"></i> Currency:
    </label>
    
    <br>

    <select id="currency_select" name="change_currency"
            class="form-select d-inline-block"
            style="width:150px;">

        <?php while ($c = $allcurrencies->fetch_assoc()): ?>
            <option value="<?= $c['currency_code'] ?>"
                data-icon="https://flagcdn.com/24x18/<?= strtolower(substr($c['currency_code'],0,2)) ?>.png"
                <?= $user_currency == $c['currency_code'] ? 'selected' : '' ?>>
                <?= $c['currency_code'] ?>
            </option>
        <?php endwhile; ?>

    </select>

</form>
<?php endif; ?>

<script>
$(document).ready(function() {

    function formatCurrency(option) {
        if (!option.id) return option.text;

        let icon = $(option.element).data('icon');
        return $(`
            <span style="display:flex;align-items:center;">
                <img src="${icon}" style="width:20px; margin-right:8px;">
                ${option.text}
            </span>
        `);
    }

    $('#currency_select').select2({
        width: '150px',
        templateResult: formatCurrency,
        templateSelection: formatCurrency,
        minimumResultsForSearch: 0 // search enabled
    });

    // Auto-submit on change
    $('#currency_select').on('change', function() {
        $(this).closest('form').submit();
    });

});
</script>



        <?php if (!empty($categories)): ?>
            <?php foreach ($categories as $category_name => $services): ?>
                <div class="category-header">
                    <i class="bi bi-tags-fill me-2"></i> <?= htmlspecialchars($category_name) ?>
                </div>

                <div class="table-responsive mt-2">
                    <table class="table table-bordered align-middle text-center">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Service</th>
                                <th>Rate (per 1000)</th>
                                <th>Min / Max</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($services as $s): ?>
                                <tr>
                                    <td><?= $s['service_id'] ?></td>
                                    <td class="text-start fw-semibold"><?= htmlspecialchars($s['service_name']) ?></td>
                                    
                                    
                                    
                                    <td class="price-tag">
                                     
                                            
                                            
                                    <?= $currency_symbol ?> ~ 
<span class="amount-value">
    <?= number_format(convertFromtoLKR($s['price'], $user_currency), 6) ?>
</span>

                                     
                                        
                                        </td>
                                    
                                    
                                    
                                    <td><?= $s['min_quantity'] ?> / <?= $s['max_quantity'] ?></td>
                                    <td class="text-center align-middle">
                                        <div class="d-inline-flex justify-content-center align-items-center flex-wrap gap-2">
                                            <?php if (!empty(trim($s['description']))): ?>
                                                <button class="btn btn-sm btn-view d-flex align-items-center"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#descModal<?= $s['service_id'] ?>">
                                                    <i class="bi bi-eye-fill me-1"></i> View
                                                </button>
                                            <?php endif; ?>

                                            <a href="index?c=<?= $s['category_id'] ?>&s=<?= $s['service_id'] ?>"
                                                class="btn btn-sm btn-cart d-flex align-items-center justify-content-center">
                                                <i class="bi bi-cart-fill"></i>
                                            </a>
                                        </div>
                                    </td>


                                </tr>

                                <!-- Bootstrap Modal for Description -->
                                <div class="modal fade" id="descModal<?= $s['service_id'] ?>" tabindex="-1" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered">
                                        <div class="modal-content custom-modal">
                                            <div class="modal-header bg-primary text-white">
                                                <h5 class="modal-title"><?= htmlspecialchars($s['service_name']) ?></h5>
                                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                                            </div>
                                            <div class="modal-body">
                                                <p class="text-dark mb-0"><?= nl2br(htmlspecialchars($s['description'] ?: 'No description available.')) ?></p>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                <a href="index?c=<?= $s['category_id'] ?>&s=<?= $s['service_id'] ?>" class="btn btn-success order-btn">
                                                    <i class="bi bi-cart-fill"></i> Order Now
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <style>
                                    /* ===== Modal Styling ===== */
                                    .custom-modal {
                                        border: none;
                                        border-radius: 16px;
                                        overflow: hidden;
                                        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.25);
                                        animation: modalPop 0.3s ease-out;
                                    }

                                    /* Modal header - gradient look */
                                    .custom-modal .modal-header {
                                        background: linear-gradient(135deg, #6c63ff, #7f6fff);
                                        color: #fff;
                                        border-bottom: none;
                                        padding: 15px 20px;
                                    }

                                    .custom-modal .modal-title {
                                        font-weight: 600;
                                        font-size: 1.1rem;
                                    }

                                    /* Body text */
                                    .custom-modal .modal-body {
                                        background: #f9f9ff;
                                        padding: 20px;
                                        font-size: 15px;
                                        line-height: 1.6;
                                        color: #333;
                                        border-bottom: 1px solid #e4e4f9;
                                    }

                                    /* Footer styling */
                                    .custom-modal .modal-footer {
                                        background: #f1f1ff;
                                        border-top: none;
                                        display: flex;
                                        justify-content: space-between;
                                        align-items: center;
                                    }

                                    /* Order Now button */
                                    .order-btn {
                                        background: linear-gradient(135deg, #00c6ff, #0072ff);
                                        border: none;
                                        color: #fff;
                                        border-radius: 30px;
                                        font-weight: 500;
                                        padding: 8px 16px;
                                        transition: all 0.3s ease;
                                        box-shadow: 0 3px 10px rgba(0, 162, 255, 0.3);
                                    }

                                    .order-btn:hover {
                                        background: linear-gradient(135deg, #00a8ff, #005ecf);
                                        transform: translateY(-2px);
                                        box-shadow: 0 6px 14px rgba(0, 162, 255, 0.4);
                                    }

                                    /* Subtle pop animation */
                                    @keyframes modalPop {
                                        0% {
                                            transform: scale(0.95);
                                            opacity: 0;
                                        }

                                        100% {
                                            transform: scale(1);
                                            opacity: 1;
                                        }
                                    }
                                </style>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="alert alert-warning text-center mt-5">
                No services found.
            </div>
        <?php endif; ?>

        <!-- ✅ Pagination -->
        <?php if ($total_pages > 1): ?>
            <nav aria-label="Page navigation" class="mt-4">
                <ul class="pagination pagination-md justify-content-center flex-wrap">

                    <!-- Prev Button -->
                    <li class="page-item <?= $page <= 1 ? 'disabled' : '' ?>">
                        <a class="page-link" href="?search=<?= urlencode($search) ?>&page=<?= $page - 1 ?>" aria-label="Previous">
                            <span aria-hidden="true">&laquo;</span> Prev
                        </a>
                    </li>

                    <!-- Page Numbers -->
                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                        <li class="page-item <?= ($i == $page) ? 'active' : '' ?>">
                            <a class="page-link" href="?search=<?= urlencode($search) ?>&page=<?= $i ?>"><?= $i ?></a>
                        </li>
                    <?php endfor; ?>

                    <!-- Next Button -->
                    <li class="page-item <?= $page >= $total_pages ? 'disabled' : '' ?>">
                        <a class="page-link" href="?search=<?= urlencode($search) ?>&page=<?= $page + 1 ?>" aria-label="Next">
                            Next <span aria-hidden="true">&raquo;</span>
                        </a>
                    </li>

                </ul>
            </nav>
        <?php endif; ?>

    </div>

    <?php include 'public/include/footer.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>